-- --------------------------------------------------------------------------------
-- 
-- @version: ddp3.sql Sep 16, 2014 01:22 gewa
-- @package Freelance Manager
-- @author wojoscripts.com.
-- @copyright 2011
-- 
-- --------------------------------------------------------------------------------
-- Host: localhost
-- Database: ddp3
-- Time: Sep 16, 2014-01:22
-- MySQL version: 5.6.12-log
-- PHP version: 5.4.12
-- --------------------------------------------------------------------------------

#
# Database: `ddp3`
#


-- --------------------------------------------------
# -- Table structure for table `cart`
-- --------------------------------------------------
DROP TABLE IF EXISTS `cart`;
CREATE TABLE `cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `price` float(7,2) DEFAULT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `cart`
-- --------------------------------------------------

INSERT INTO `cart` (`id`, `user_id`, `pid`, `price`, `uid`) VALUES ('38', '189e25bb99c3b09c37425a0b9cbffaa4e18d9304', '38', '2.99', '0');
INSERT INTO `cart` (`id`, `user_id`, `pid`, `price`, `uid`) VALUES ('39', '189e25bb99c3b09c37425a0b9cbffaa4e18d9304', '37', '11.99', '0');
INSERT INTO `cart` (`id`, `user_id`, `pid`, `price`, `uid`) VALUES ('40', '189e25bb99c3b09c37425a0b9cbffaa4e18d9304', '36', '11.99', '0');


-- --------------------------------------------------
# -- Table structure for table `categories`
-- --------------------------------------------------
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `parent_id` int(6) NOT NULL DEFAULT '0',
  `slug` varchar(200) NOT NULL,
  `description` text,
  `position` tinyint(2) NOT NULL DEFAULT '0',
  `metakeys` text NOT NULL,
  `metadesc` text NOT NULL,
  `active` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `categories`
-- --------------------------------------------------

INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('1', 'Cookbooks', '0', 'Cookbooks', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '1', 'Cookbooks', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('14', 'Drama', '2', 'Drama', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '8', 'Drama', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('2', 'Fiction', '0', 'Fiction', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '7', 'Fiction', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('3', 'Biography', '0', 'Biography', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '12', 'Biography', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('13', 'Horor', '2', 'Horor', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '9', 'Horor', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('4', 'Vegetarian', '1', 'Vegetarian', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '6', 'Vegetarian', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('10', 'Baking', '1', 'Baking', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '2', 'Baking', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('5', 'Computers', '0', 'Computers', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '13', 'Computers', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('6', 'Home &amp; Garden', '0', 'Home-Garden', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '14', 'Home &amp; Garden', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('12', 'Deserts', '1', 'Deserts', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '3', 'Deserts', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('7', 'Travel', '0', 'Travel', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '15', 'Travel', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('8', 'Westerns', '0', 'Westerns', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '16', 'Westerns', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('11', 'Wine &amp; Beverages', '1', 'Wine-Beverages', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '5', 'Wine &amp; Beverages', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('15', 'Romance', '2', 'Romance', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '10', 'Romance', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('16', 'World Literature', '2', 'World-Literature', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '11', 'World Literature', '', '1');
INSERT INTO `categories` (`id`, `name`, `parent_id`, `slug`, `description`, `position`, `metakeys`, `metadesc`, `active`) VALUES ('17', 'Pies', '12', 'pies', 'liquam in sapien non sem ultrices luctus. Vestibulum non orci ac nisl egestas ultrices quis eget mauris. Vestibulum commodo lorem eu nisl pellentesque faucibus. Vestibulum a erat nunc, eu cursus tellus.', '4', 'Pies', '', '1');


-- --------------------------------------------------
# -- Table structure for table `categories_related`
-- --------------------------------------------------
DROP TABLE IF EXISTS `categories_related`;
CREATE TABLE `categories_related` (
  `pid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  PRIMARY KEY (`pid`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `categories_related`
-- --------------------------------------------------

INSERT INTO `categories_related` (`pid`, `cid`) VALUES ('39', '7');
INSERT INTO `categories_related` (`pid`, `cid`) VALUES ('41', '1');
INSERT INTO `categories_related` (`pid`, `cid`) VALUES ('41', '12');
INSERT INTO `categories_related` (`pid`, `cid`) VALUES ('41', '17');


-- --------------------------------------------------
# -- Table structure for table `comments`
-- --------------------------------------------------
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(24) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `email` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `body` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `www` varchar(220) DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(16) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `comments`
-- --------------------------------------------------

INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('1', '39', 'Webmaster', '1', 'webmaster@wojoscripts.com', 'First comment is on me.', 'http://www.wojoscripts.com', '2011-06-20 16:34:55', '127.0.0.1', '1');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('2', '39', 'Admin', '0', 'webmaster@wojoscripts.com', '<pre>Cum sociis natoque penatibus et <strong>magnis dis parturient</strong> montes, </pre>nascetur ridiculus mus. Nam nec odio nulla. Cras ullamcorper suscipit justo, at mattis odio auctor quis.', '', '2011-06-24 16:34:55', '127.0.0.1', '1');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('3', '39', 'User1', '0', 'user1@mail.com', 'Ut dictum, eros eu blandit pellentesque, nisi nisl dapibus mauris, sed feugiat enim urna sit amet nibh. Suspendisse sed tortor nisi. Nulla facilisi. In sed risus in est cursus ornare.', '', '2011-06-25 16:34:55', '127.0.0.1', '1');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('4', '39', 'User2', '0', 'user2@mail.com', 'Etiam non lacus ac velit <em>lobortis rutrum sed</em> id turpis. <code>Ut dictum, eros eu blandit pellentesque, nisi nisl dapibus mauris,</code>sed feugiat enim urna sit amet nibh. Suspendisse sed tortor nisi. Nulla facilisi. In sed risus in est cursus ornare. Fusce tempor hendrerit commodo.', '', '2011-06-26 10:34:55', '127.0.0.1', '1');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('5', '39', 'User3', '0', 'user3@mail.com', 'In hac habit***e platea dictumst.ivamus leo diam, dignissim eu convallis in, posuere quis magna. Curabitur mollis, lectus sit amet bibendum faucibus, nisi ligula ultricies purus', '', '2011-06-27 16:34:55', '127.0.0.1', '1');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('6', '39', 'User4', '0', 'user4@mail.com', 'Morbi sodales accumsan arcu sed venenatis. Vivamus leo diam, dignissim eu convallis in, posuere quis magna. Curabitur mollis, lectus sit amet bibendum faucibus, nisi ligula ultricies purus, in malesuada arcu sem ut mauris. Proin lobortis rutrum ultrices.', '', '2011-06-30 16:34:55', '127.0.0.1', '0');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('7', '39', 'admin', '0', 'webmaster@wojoscripts.com', 'Ut dictum, eros eu blandit pellentesque, nisi nisl dapibus mauris, sed feugiat enim urna sit amet nibh. Suspendisse sed tortor nisi. Nulla facilisi. In sed risus in est cursus ornare....', 'http://www.wojoscripts.com', '2011-07-25 17:02:24', '127.0.0.1', '1');
INSERT INTO `comments` (`id`, `pid`, `username`, `uid`, `email`, `body`, `www`, `created`, `ip`, `active`) VALUES ('10', '2', 'admin', '0', 'alex.kuzmanovic@gmail.com', 'My coment goes here', '', '2013-11-21 18:59:10', '127.0.0.1', '0');


-- --------------------------------------------------
# -- Table structure for table `comments_config`
-- --------------------------------------------------
DROP TABLE IF EXISTS `comments_config`;
CREATE TABLE `comments_config` (
  `username_req` tinyint(1) NOT NULL,
  `email_req` tinyint(1) NOT NULL,
  `show_captcha` tinyint(1) NOT NULL,
  `show_www` tinyint(1) NOT NULL,
  `show_username` tinyint(1) NOT NULL,
  `show_email` tinyint(1) NOT NULL,
  `auto_approve` tinyint(1) NOT NULL,
  `notify_new` tinyint(1) NOT NULL,
  `public_access` tinyint(1) NOT NULL,
  `sorting` char(4) NOT NULL,
  `blacklist_words` text NOT NULL,
  `char_limit` smallint(4) NOT NULL,
  `perpage` tinyint(2) NOT NULL,
  `dateformat` char(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `comments_config`
-- --------------------------------------------------

INSERT INTO `comments_config` (`username_req`, `email_req`, `show_captcha`, `show_www`, `show_username`, `show_email`, `auto_approve`, `notify_new`, `public_access`, `sorting`, `blacklist_words`, `char_limit`, `perpage`, `dateformat`) VALUES ('1', '1', '1', '1', '1', '0', '0', '1', '1', 'DESC', 'arse\narses\nass\nasses\nbollocks\ncrap', '300', '10', '%B %d, %Y %I:%M %p');


-- --------------------------------------------------
# -- Table structure for table `coupons`
-- --------------------------------------------------
DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `code` varchar(100) NOT NULL,
  `discount` varchar(4) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `minval` decimal(10,2) NOT NULL,
  `validuntil` date NOT NULL DEFAULT '0000-00-00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `coupons`
-- --------------------------------------------------

INSERT INTO `coupons` (`id`, `title`, `code`, `discount`, `type`, `minval`, `validuntil`, `created`, `active`) VALUES ('1', 'Demo Coupon', '123456', '10', '0', '10.00', '2014-12-27', '2014-09-09 02:05:05', '1');


-- --------------------------------------------------
# -- Table structure for table `email_templates`
-- --------------------------------------------------
DROP TABLE IF EXISTS `email_templates`;
CREATE TABLE `email_templates` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `help` text,
  `body` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=128 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `email_templates`
-- --------------------------------------------------

INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('1', 'Registration Email', 'Please verify your email', 'This template is used to send Registration Verification Email, when Configuration-&gt;Registration Verification is set to YES', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tWelcome [NAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tHello, &lt;br&gt;\n\t\t\t&lt;br&gt;\n          You&#039;re now a member of [SITE_NAME]. \n\t\t\t&lt;br&gt;\n          Here are your login details. Please keep them in a safe place:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[USERNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Password:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PASSWORD]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tThe administrator of this site has requested all new accounts\n          to be activated by the users who created them thus your account\n          is currently inactive. \n\t\t\t&lt;br&gt;\n\t\t\tTo activate your account,\n          please visit the link below and enter the following:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table border=&quot;0&quot; cellpadding=&quot;4&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Token:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[TOKEN]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Email:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[EMAIL]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;a href=&quot;[LINK]&quot;&gt;&lt;b&gt;Click here to activate your account&lt;/b&gt;&lt;/a&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('2', 'Forgot Password Email', 'Password Reset', 'This template is used for retrieving lost user password', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color:#ccc; font-size:16px;padding:5px;border-bottom:2px solid #fff;&quot;&gt;\n\t\t\tNew password reset from [SITE_NAME]!\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tHello, &lt;b&gt;[USERNAME]&lt;/b&gt;&lt;br&gt;\n\t\t\t&lt;br&gt;\n          It seems that you or someone requested a new password for you.\n\t\t\t&lt;br&gt;\n          We have generated a new password, as requested:\n\t\t\t&lt;br&gt;\n\t\t\t&lt;br&gt;\n          Your new password: \n\t\t\t&lt;b&gt;[PASSWORD]&lt;/b&gt;&lt;br&gt;\n\t\t\t&lt;br&gt;\n          To use the new password you need to activate it. To do this click the link provided below and login with your new password.\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[LINK]&quot;&gt;[LINK]&lt;/a&gt;&lt;br&gt;\n\t\t\t&lt;br&gt;\n          You can change your password after you sign in.\n\t\t\t&lt;hr&gt;\n          Password requested from IP: [IP]\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('3', 'Welcome Mail From Admin', 'You have been registered', 'This template is used to send welcome email, when user is added by administrator', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tWelcome [NAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tHello, &lt;br&gt;\n\t\t\t&lt;br&gt;\n          You&#039;re now a member of [SITE_NAME]. \n\t\t\t&lt;br&gt;\n          Here are your login details. Please keep them in a safe place:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[USERNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Password:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PASSWORD]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('4', 'Default Newsletter', 'Newsletter', 'This is a default newsletter template', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello [NAME]!\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tYou are receiving this email as a part of your newsletter subscription.\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t Here goes your newsletter content...\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;background-color:#f1f1f1;border-top-width:2px; border-top-color:#fff; border-top-style:solid&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;To stop receiving future newsletters please login into your account         and uncheck newsletter subscription box.&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('5', 'Transaction Completed', 'Payment Completed', 'This template is used to notify administrator on successful payment transaction', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello, Admin\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left&quot;&gt;\n\t\t\tYou have received new payment transaction:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[USERNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Status:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[STATUS]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Amount:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[TOTAL]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Processor:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;IP:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[IP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;&lt;b&gt;You can view this transaction from your admin panel.&lt;/b&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('6', 'Transaction Suspicious', 'Suspicious Transaction', 'This template is used to notify administrator on failed/suspicious payment transaction', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello, Admin\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left&quot;&gt;\n\t\t\tThe following transaction has been disabled due to suspicious activity:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[USERNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Status:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[STATUS]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Amount:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[TOTAL]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Processor:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;IP:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[IP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Please verify this transaction is correct.  It appears that someone tried to fraudulently obtain products from your site.&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('7', 'Welcome Email', 'Welcome', 'This template is used to welcome newly registered user when Configuration-&gt;Registration Verification and Configuration-&gt;Auto Registration are both set to YES', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tWelcome [NAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tHello, &lt;br&gt;\n\t\t\t&lt;br&gt;\n          You&#039;re now a member of [SITE_NAME]. \n\t\t\t&lt;br&gt;\n          Here are your login details. Please keep them in a safe place:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[USERNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Password:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PASSWORD]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('8', 'Transaction Completed User', 'Transaction Completed', 'This template is used to notify user on successful purchase.', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello [USERNAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou have purchased the following:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t[ITEMS]\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou can now download your item(s) from your control panel.\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('9', 'Notify User Transaction', 'Your product is ready for download', 'This template is used to notify user when manual transaction has been processed.', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello [USERNAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYour product is ready for download:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Product:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[ITEMNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Price:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PRICE]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Quantity:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[QTY]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou can now download your item(s) from your control panel.\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITENAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('10', 'Contact Request', 'Contact Inquiry', 'This template is used to send default Contact Request Form.', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color:#ccc; font-size:16px;padding:5px;border-bottom:2px solid #fff;&quot;&gt;\n\t\t\t Hello, Admin\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left&quot;&gt;\n\t\t\t You have received new contact request:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot; width=&quot;150&quot;&gt;\n\t\t\t\t\t&lt;b&gt;From:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot;&gt;\n\t\t\t\t\t [SENDER] - [NAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot; width=&quot;150&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Subject:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot;&gt;\n\t\t\t\t\t [MAILSUBJECT]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot; width=&quot;150&quot;&gt;\n\t\t\t\t\t&lt;b&gt;IP:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot;&gt;\n\t\t\t\t\t [IP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot; width=&quot;150&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Message:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid;&quot;&gt;\n\t\t\t\t\t[MESSAGE]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('12', 'Single Email', 'Single User Email', 'This template is used to email single user', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello [NAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYour message goes here...\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('13', 'Notify Admin', 'New User Registration', 'This template is used to notify admin of new registration when Configuration-&gt;Registration Notification is set to YES', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello Admin\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou have a new user registration:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[SENDER] - [NAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Name:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[WWW]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;IP:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[IP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou can login into your admin panel to view details.\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('14', 'Registration Pending', 'Registration Verification Pending', 'This template is used to send Registration Verification Email, when Configuration-&gt;Auto Registration is set to NO', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n  &lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tWelcome [NAME]\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tHello, &lt;br&gt;\n\t\t\t&lt;br&gt;\n          You&#039;re now a member of [SITE_NAME]. \n\t\t\t&lt;br&gt;\n          Here are your login details. Please keep them in a safe place:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Username:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[USERNAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Password:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[PASSWORD]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tThe administrator of this site has requested all new accounts\n          to be activated by the users who created them thus your account\n          is currently pending verification process.\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n          [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('11', 'New Comment', 'New Comment Added', 'This template is used to notify admin when new comment has been added.', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color: rgb(204, 204, 204); font-size:16px;padding:5px;border-bottom-width:2px; border-bottom-color:#fff; border-bottom-style:solid&quot;&gt;\n\t\t\tHello Admin\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou have a new comment post:\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;&quot; border=&quot;0&quot; width=&quot;100%&quot; cellpadding=&quot;5&quot; cellspacing=&quot;2&quot;&gt;\n\t\t\t&lt;tbody&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot; width=&quot;130&quot;&gt;\n\t\t\t\t\t&lt;b&gt;From:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[SENDER] - [NAME]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;www:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[WWW]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;Product Url:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t&lt;a href=&quot;[PAGEURL]&quot;&gt;[PAGEURL]&lt;/a&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;right&quot;&gt;\n\t\t\t\t\t&lt;b&gt;IP:&lt;/b&gt;\n\t\t\t\t&lt;/td&gt;\n\t\t\t\t&lt;td style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot;&gt;\n\t\t\t\t\t[IP]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;tr&gt;\n\t\t\t\t&lt;td colspan=&quot;2&quot; style=&quot;border-bottom-width:1px; border-bottom-color:#bbb; border-bottom-style:dashed&quot; align=&quot;left&quot;&gt;\n\t\t\t\t\t[MESSAGE]\n\t\t\t\t&lt;/td&gt;\n\t\t\t&lt;/tr&gt;\n\t\t\t&lt;/tbody&gt;\n\t\t\t&lt;/table&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left; background-color:#fff;border-top-width:2px; border-top-color:#ccc; border-top-style:solid&quot; valign=&quot;top&quot;&gt;\n\t\t\tYou can login into your admin panel to view details\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');
INSERT INTO `email_templates` (`id`, `name`, `subject`, `help`, `body`) VALUES ('15', 'Account Activation', 'Your account have been activated', 'This template is used to notify user when manual account activation is completed', '&lt;div style=&quot;color:#000;margin-top:20px;margin-left:auto;margin-right:auto;max-width:800px;background-color:#F4F4F4&quot;&gt;\n\t&lt;table style=&quot;font-family: Helvetica Neue,Helvetica,Arial, sans-serif; font-size:13px;background: #F4F4F4; width: 100%; border: 4px solid #bbbbbb;&quot; cellpadding=&quot;10&quot; cellspacing=&quot;5&quot;&gt;\n\t&lt;tbody&gt;\n\t&lt;tr&gt;\n\t\t&lt;th style=&quot;background-color:#ccc; font-size:16px;padding:5px;border-bottom:2px solid #fff;&quot;&gt;\n\t\t\tHello, [NAME]! &lt;br&gt;\n\t\t&lt;/th&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot; valign=&quot;top&quot;&gt;\n\t\t\tHello,&lt;br&gt;\n\t\t\t&lt;br&gt;\n            You&#039;re now a member of [SITE_NAME].\n\t\t\t&lt;br&gt;\n\t\t\t&lt;br&gt;\n            Your account is now fully activated\n            , and you may login at \n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;\n\t\t\t&lt;hr&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;tr&gt;\n\t\t&lt;td style=&quot;text-align: left;&quot;&gt;\n\t\t\t&lt;i&gt;Thanks,&lt;br&gt;\n            [SITE_NAME] Team\n\t\t\t&lt;br&gt;\n\t\t\t&lt;a href=&quot;[URL]&quot;&gt;[URL]&lt;/a&gt;&lt;/i&gt;\n\t\t&lt;/td&gt;\n\t&lt;/tr&gt;\n\t&lt;/tbody&gt;\n\t&lt;/table&gt;\n&lt;/div&gt;');


-- --------------------------------------------------
# -- Table structure for table `extras`
-- --------------------------------------------------
DROP TABLE IF EXISTS `extras`;
CREATE TABLE `extras` (
  `user_id` varchar(50) NOT NULL DEFAULT '0',
  `coupon` decimal(10,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `extras`
-- --------------------------------------------------



-- --------------------------------------------------
# -- Table structure for table `faq`
-- --------------------------------------------------
DROP TABLE IF EXISTS `faq`;
CREATE TABLE `faq` (
  `id` tinyint(3) NOT NULL AUTO_INCREMENT,
  `question` varchar(150) DEFAULT NULL,
  `answer` text,
  `position` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `faq`
-- --------------------------------------------------

INSERT INTO `faq` (`id`, `question`, `answer`, `position`) VALUES ('1', 'Selling Applications', 'DDP is well suited for a range of selling applications and markets.  \nFrom simple single product ebook sites to complete music or software \nstorefronts, DDP has the selling features you need.', '2');
INSERT INTO `faq` (`id`, `question`, `answer`, `position`) VALUES ('2', 'Coupon / Discount Codes', 'Coupons can be worth either a fixed value price or a percentage of the cart total.', '3');
INSERT INTO `faq` (`id`, `question`, `answer`, `position`) VALUES ('3', 'Download Security Features', 'DDP&#039;s innovative system prevents download link sharing and discovery to prevent unauthorized download of your valuable products.', '1');
INSERT INTO `faq` (`id`, `question`, `answer`, `position`) VALUES ('4', 'Sell Downloads with PayPal', 'PayPal is the most popular payment processor in the world with millions of users. DDP supports PayPal transactions using the Website Payments Standard system that requires no additional monthly fees from PayPal. Vendors wishing to use PayPal as their payment processor must have a Business or Premiere PayPal account to use Website Payments Standard with DDP.', '4');
INSERT INTO `faq` (`id`, `question`, `answer`, `position`) VALUES ('5', 'Multi-Item Cart', 'DDP&#039;s multi-item checkout, compatible with PayPal, MoneyBookers and AlertPay, offers full shopping cart functionality.', '5');


-- --------------------------------------------------
# -- Table structure for table `files`
-- --------------------------------------------------
DROP TABLE IF EXISTS `files`;
CREATE TABLE `files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `filesize` varchar(80) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `files`
-- --------------------------------------------------

INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('1', 'testfile1.zip', 'Demo File 1', '19456', '2011-07-21 15:42:11', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('2', 'testfile2.zip', 'Demo File 2', '23552', '2011-07-21 15:42:21', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('3', 'testfile3.zip', 'Demo File 3', '11264', '2011-07-21 15:42:29', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('4', 'testfile4.zip', 'Demo File 4', '7168', '2011-07-21 15:42:37', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('5', 'testfile5.zip', 'Demo File 5', '9216', '2011-07-21 15:42:49', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('6', 'testpdf1.pdf', 'Demo File 6', '19456', '2011-07-21 15:47:18', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('7', 'testpdf2.pdf', 'Demo File 7', '23552', '2011-07-21 15:47:29', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('8', 'testpdf3.pdf', 'Demo File 8', '11264', '2011-07-21 15:47:44', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('9', 'testfilems1.doc', 'Demo File 9', '19456', '2011-07-21 15:51:16', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('10', 'testfilems2.docx', 'Demo File 10', '23552', '2011-07-21 15:51:24', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('11', 'testfilems4.xls', 'Demo File 11', '7168', '2011-07-21 15:51:32', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('12', 'testfilems5.xlsx', 'Demo File 12', '9216', '2011-07-21 15:51:43', '1');
INSERT INTO `files` (`id`, `name`, `alias`, `filesize`, `created`, `active`) VALUES ('13', 'FILE_836B83.rar', 'New CMS pro', '26413698', '2013-10-13 01:16:52', '1');


-- --------------------------------------------------
# -- Table structure for table `gateways`
-- --------------------------------------------------
DROP TABLE IF EXISTS `gateways`;
CREATE TABLE `gateways` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `displayname` varchar(200) NOT NULL,
  `dir` varchar(200) NOT NULL,
  `demo` tinyint(1) NOT NULL DEFAULT '1',
  `extra_txt` varchar(200) NOT NULL,
  `extra_txt2` varchar(200) NOT NULL,
  `extra_txt3` varchar(200) DEFAULT NULL,
  `extra` varchar(200) NOT NULL,
  `extra2` varchar(200) NOT NULL,
  `extra3` varchar(200) DEFAULT NULL,
  `info` text,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `gateways`
-- --------------------------------------------------

INSERT INTO `gateways` (`id`, `name`, `displayname`, `dir`, `demo`, `extra_txt`, `extra_txt2`, `extra_txt3`, `extra`, `extra2`, `extra3`, `info`, `active`) VALUES ('1', 'paypal', 'PayPal', 'paypal', '0', 'Paypal Email Address', 'Currency Code', 'Not in Use', 'paypal@address.com', 'CAD', '', '&lt;p&gt;&lt;a href=&quot;http://www.paypal.com/&quot; title=&quot;PayPal&quot; rel=&quot;nofollow&quot; target=&quot;_blank&quot;&gt;Click here to setup an account with Paypal&lt;/a&gt; &lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n\t\t\tIf this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Paypal email address&lt;/strong&gt; - Enter your PayPal Business email address here. &lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Currency Code&lt;/strong&gt; - Enter your currency code here. Valid choices are: &lt;/p&gt;\r\n\t\t\t\t&lt;ul&gt;\r\n\t\t\t\t\t&lt;li&gt; USD (U.S. Dollar)&lt;/li&gt;\r\n\t\t\t\t\t&lt;li&gt; EUR (Euro) &lt;/li&gt;\r\n\t\t\t\t\t&lt;li&gt; GBP (Pound Sterling) &lt;/li&gt;\r\n\t\t\t\t\t&lt;li&gt; CAD (Canadian Dollar) &lt;/li&gt;\r\n\t\t\t\t\t&lt;li&gt; JPY (Yen). &lt;/li&gt;\r\n\t\t\t\t\t&lt;li&gt; If omitted, all monetary fields will use default system setting Currency Code. &lt;/li&gt;\r\n\t\t\t\t&lt;/ul&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Not in Use&lt;/strong&gt; - This field it&#039;s not in use. Leave it empty. &lt;/p&gt;\r\n\t        &lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - If using recurring payment method, you need to set up and activate the IPN Url in your account: &lt;/p&gt;', '1');
INSERT INTO `gateways` (`id`, `name`, `displayname`, `dir`, `demo`, `extra_txt`, `extra_txt2`, `extra_txt3`, `extra`, `extra2`, `extra3`, `info`, `active`) VALUES ('2', 'skrill', 'Skrill', 'skrill', '0', 'Skrill Email Address', 'Currency Code', 'Secret Passphrase', 'gewa@rogers.com', 'EUR', 'mypassphrase', '&lt;p&gt;&lt;a href=&quot;http://www.moneybookers.com/&quot; title=&quot;http://www.moneybookers.net/&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with MoneyBookers&lt;/a&gt;&lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n\t\t\tIf this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - MoneyBookers does not have demo mode. You need to open testing acounts. One seller and one buyer. &lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;MoneyBookers email address&lt;/strong&gt; - Enter your MoneyBookers email address here. &lt;/p&gt;\r\n\t\t\t&lt;p&gt;&lt;strong&gt;Secret Passphrase&lt;/strong&gt; - This field must be set at Moneybookers.com.&lt;/p&gt;\r\n\t        &lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - If using recurring payment method, you need to set up and activate the IPN Url in your account: &lt;/p&gt;', '1');
INSERT INTO `gateways` (`id`, `name`, `displayname`, `dir`, `demo`, `extra_txt`, `extra_txt2`, `extra_txt3`, `extra`, `extra2`, `extra3`, `info`, `active`) VALUES ('3', 'payza', 'Payza', 'payza', '0', 'Payza Email Address', 'Currency Code', 'IPN Security Code', 'seller_1_alex.kuzmanovic@gmail.com', 'USD', 'd9vL9oYVOGpmVM2i', '&lt;p&gt;&lt;a href=&quot;http://www.payza.com/&quot; title=&quot;http://www.payza.com/&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with Payza&lt;/a&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n  If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;AlertPay email address&lt;/strong&gt; - Enter your Payza email address here. &lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;IPN Security Code&lt;/strong&gt; - This code needs to be generated in your Payza control panel.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - This has to be set in the Payza control panel. You will also need to check the &quot;IPN Status&quot; to enabled.&lt;/p&gt;', '1');


-- --------------------------------------------------
# -- Table structure for table `menus`
-- --------------------------------------------------
DROP TABLE IF EXISTS `menus`;
CREATE TABLE `menus` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `page_id` tinyint(2) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `content_type` varchar(20) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `target` enum('_self','_blank') NOT NULL DEFAULT '_blank',
  `position` tinyint(2) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `content_id` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `menus`
-- --------------------------------------------------

INSERT INTO `menus` (`id`, `page_id`, `name`, `content_type`, `link`, `target`, `position`, `active`) VALUES ('1', '4', 'Contact Us', 'page', '', '', '5', '1');
INSERT INTO `menus` (`id`, `page_id`, `name`, `content_type`, `link`, `target`, `position`, `active`) VALUES ('2', '1', 'Home', 'page', '', '', '1', '1');
INSERT INTO `menus` (`id`, `page_id`, `name`, `content_type`, `link`, `target`, `position`, `active`) VALUES ('3', '2', 'About Us', 'page', '', '', '3', '1');
INSERT INTO `menus` (`id`, `page_id`, `name`, `content_type`, `link`, `target`, `position`, `active`) VALUES ('4', '3', 'F.A.Q.', 'page', '', '', '2', '1');
INSERT INTO `menus` (`id`, `page_id`, `name`, `content_type`, `link`, `target`, `position`, `active`) VALUES ('22', '0', 'Ext Link', 'web', 'http://www.google.com', '_blank', '4', '1');


-- --------------------------------------------------
# -- Table structure for table `news`
-- --------------------------------------------------
DROP TABLE IF EXISTS `news`;
CREATE TABLE `news` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `body` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `author` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `created` date NOT NULL DEFAULT '0000-00-00',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `news`
-- --------------------------------------------------

INSERT INTO `news` (`id`, `title`, `body`, `author`, `created`, `active`) VALUES ('1', 'Latest News Announcement', '&lt;p&gt;We are pleased to announce the new release of Digital Downloads Pro v 3..0&lt;/p&gt;This version brings lot&#039;s of new features, as well as being completely rewritten from scratch. One of the being fully responsive. In this demo as you can see we are using DDP to sell e-books, but you can use it to sell software, audio/video products, images or anything else in downloadable format.&lt;br&gt;&lt;br&gt;We hope you find this version to your liking. To access admin area go to: &lt;a href=&quot;admin/login.php&quot;&gt;admin panel&lt;/a&gt; &lt;br&gt;&lt;b&gt;username/password&amp;nbsp;&amp;nbsp; admin/admin&lt;/b&gt;', 'Administrator', '2014-09-13', '0');


-- --------------------------------------------------
# -- Table structure for table `pages`
-- --------------------------------------------------
DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `slug` varchar(50) NOT NULL,
  `body` longtext,
  `created` datetime NOT NULL,
  `contact` tinyint(1) NOT NULL DEFAULT '0',
  `faq` tinyint(1) NOT NULL DEFAULT '0',
  `home_page` tinyint(1) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `pages`
-- --------------------------------------------------

INSERT INTO `pages` (`id`, `title`, `slug`, `body`, `created`, `contact`, `faq`, `home_page`, `active`) VALUES ('1', 'Welcome to our site', 'welcome-to-our-site', '&lt;p&gt;&lt;b&gt;Welcome!&lt;/b&gt;&lt;br&gt;Quisque fringilla ullamcorper est, et egestas nunc luctus quis. In  cursus tortor arcu, quis fermentum ligula. &lt;br&gt;Vestibulum rutrum diam ut  mauris gravida varius. Pellentesque id ligula ullamcorper velit laoreet  volutpat gravida sit amet nulla. &lt;br&gt;&lt;br&gt;Vivamus consequat feugiat viverra. In  nunc erat, convallis in viverra ac, placerat semper enim. &lt;br&gt;Mauris euismod  lectus sed arcu ultrices egestas. Integer tempus posuere luctus. &lt;br&gt;Ut at  malesuada mi. Integer mattis aliquet varius&lt;/p&gt;', '2014-09-13 00:00:00', '0', '0', '1', '1');
INSERT INTO `pages` (`id`, `title`, `slug`, `body`, `created`, `contact`, `faq`, `home_page`, `active`) VALUES ('2', 'About Us', 'about-us', '&lt;p&gt;&lt;b&gt;All about us!&lt;/b&gt;&lt;br&gt;&lt;br&gt;Suspendisse vel nibh at eros blandit aliquet non vel ligula. Praesent  laoreet nibh sit amet neque imperdiet eu tempor felis pharetra. &lt;br&gt;Class  aptent taciti sociosqu ad litora torquent per conubia nostra, per  inceptos himenaeos. &lt;br&gt;&lt;br&gt;Vivamus iaculis tristique sapien quis consectetur.  Curabitur sollicitudin, ante at sagittis suscipit, nulla risus facilisis  neque, eu consectetur mi sem sed lectus. Aliquam erat volutpat. Proin  in ante risus. Etiam pulvinar vestibulum laoreet. &lt;br&gt;&lt;br&gt;Vivamus venenatis  consectetur libero quis consequat. Vivamus ut lorem diam. Cras interdum  sem sed risus dictum fringilla. Sed sagittis turpis ut nisi faucibus  pellentesque. Nunc sit amet semper erat.&lt;/p&gt;', '2014-09-02 00:00:00', '0', '0', '0', '1');
INSERT INTO `pages` (`id`, `title`, `slug`, `body`, `created`, `contact`, `faq`, `home_page`, `active`) VALUES ('3', 'F.A.Q.', 'faq', 'Here you can find most common questions regarding DDP', '2014-08-06 00:00:00', '0', '1', '0', '1');
INSERT INTO `pages` (`id`, `title`, `slug`, `body`, `created`, `contact`, `faq`, `home_page`, `active`) VALUES ('4', 'Contact Us', 'contact-us', '&lt;p style=&quot;font-family: Arial, Verdana; line-height: normal; &quot;&gt;&lt;b&gt;Need to contact us?&lt;/b&gt;&lt;/p&gt;\n&lt;p style=&quot;font-family: Arial, Verdana; line-height: normal; &quot;&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris congue  vehicula enim id condimentum. &lt;br&gt;Integer at leo lobortis libero fermentum  cursus. Mauris nulla nibh, condimentum ac cursus ac, ullamcorper eu  orci. &lt;br&gt;&lt;br&gt;Nunc at ligula erat. Nunc tempor dictum commodo. Nulla aliquam  scelerisque luctus. Donec non suscipit enim. &lt;br&gt;Donec diam turpis,  facilisis et pretium vitae, adipiscing id nibh. Nullam vel orci vitae  erat mattis mattis. &lt;br&gt;&lt;br&gt;Quisque at vehicula ante. Pellentesque habitant  morbi tristique senectus et netus et malesuada fames ac turpis egestas.  Sed turpis felis, egestas vitae tincidunt nec, ullamcorper non nisi.&lt;/p&gt;', '2014-09-01 00:00:00', '1', '0', '0', '1');
INSERT INTO `pages` (`id`, `title`, `slug`, `body`, `created`, `contact`, `faq`, `home_page`, `active`) VALUES ('5', 'Other page', 'other-page', '&lt;p&gt;Sed eu lorem ut diam feugiat vulputate sed a enim. Aenean interdum, dui a  varius facilisis, metus est imperdiet justo, pharetra auctor ipsum  lorem non mauris. Mauris laoreet lectus lacus. Maecenas ut enim diam,  non malesuada sapien. Fusce ullamcorper pretium risus, eu volutpat dolor  dapibus sit amet&lt;/p&gt;', '2014-08-07 00:00:00', '0', '0', '0', '1');


-- --------------------------------------------------
# -- Table structure for table `photos`
-- --------------------------------------------------
DROP TABLE IF EXISTS `photos`;
CREATE TABLE `photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `caption` varchar(150) NOT NULL,
  `thumb` varchar(80) NOT NULL,
  `ordering` varchar(3) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `photos`
-- --------------------------------------------------

INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('1', '39', 'Demo Item 1', 'IMG_0BB5D8-93DF09-F7800E-4440CE-58F814-08DEE6.jpg', '0', '0');
INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('2', '39', 'Demo Item 2', 'IMG_FB9B3D-C1CD72-84A8BB-236C2D-7016C0-04B2DD.jpg', '0', '0');
INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('3', '39', 'Demo Item 3', 'IMG_FF567D-271E73-EE4EB5-9C0ACE-807991-AB9EA8.jpg', '0', '0');
INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('4', '39', 'Demo Item 4', 'IMG_C017D3-73951A-1FCC17-E76C1D-9FB80A-16476C.jpg', '0', '0');
INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('5', '39', 'Demo Item 5', 'IMG_9553FA-D70D81-7D76B9-8988F6-3A5DA4-E51455.jpg', '0', '0');
INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('6', '39', 'Demo Item 6', 'IMG_CB73B5-87EB15-D133AB-0BD89E-07F259-B96B33.jpg', '0', '0');
INSERT INTO `photos` (`id`, `pid`, `caption`, `thumb`, `ordering`, `active`) VALUES ('7', '39', 'Demo Item 7', 'IMG_ED0E0D-278569-CFFD63-69A4C2-A509E1-6C2E5F.jpg', '0', '0');


-- --------------------------------------------------
# -- Table structure for table `products`
-- --------------------------------------------------
DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL,
  `slug` varchar(150) NOT NULL,
  `price` decimal(7,2) NOT NULL DEFAULT '0.00',
  `description` text,
  `body` text,
  `file_id` int(5) NOT NULL,
  `thumb` varchar(50) DEFAULT NULL,
  `preview` varchar(150) DEFAULT NULL,
  `affiliate` varchar(100) DEFAULT NULL,
  `audio` varchar(50) DEFAULT NULL,
  `youtube` varchar(200) DEFAULT NULL,
  `expiry` varchar(6) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `hits` mediumint(6) NOT NULL DEFAULT '0',
  `vote_up` int(6) DEFAULT '0',
  `vote_down` int(6) DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `ratingc` int(6) NOT NULL DEFAULT '0',
  `metakeys` text,
  `metadesc` text,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `index` (`title`,`body`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `products`
-- --------------------------------------------------

INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('1', '1', 'Crock Pot Cookbook', 'crock-pot-cookbook', '0.99', 'The book has been organized by category (Beef, Casseroles, Chicken &amp; Turkey, Desserts, Dips &amp; Fondues, Pasta, Pork, Sausage, Seafood, Soups/Stews/Chili, and Vegetable Recipes) with a table of contents that makes it easy to find what you want.', 'The book has been organized by category (Beef, Casseroles, Chicken &amp;amp; Turkey, Desserts, Dips &amp;amp; Fondues, Pasta, Pork, Sausage, Seafood, Soups/Stews/Chili, and Vegetable Recipes) with a table of contents that makes it easy to find what you want.  &lt;br&gt;&lt;br&gt;So, if you&#039;ve got a chicken sitting in your fridge screaming at you to do something before it gets too old you can go to the &quot;Chicken and Turkey&quot; section and scan through the titles or click on the first one and start glancing at the recipes until you find something that strikes your fancy.', '1', 'IMG_7FDD27-1264DB-1AC810-BDE154-BECDDF-8A506D.jpg', '', '', '', '', 'D365', '2011-07-21 22:32:14', '8', '1', '0', '4', '1', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('2', '1', 'Ultimate Casseroles', 'Ultimate-Casseroles', '0.99', 'Ultimate Casseroles is a collection of over 500 casserole recipes. Everyone loves casseroles, and here you&#039;ll find plenty to satisfy everyone&#039;s taste - Beef, Lamb, Chicken, Turkey, Pork, Sausage, Seafood, Vegetable, and Fruit casseroles', 'Ultimate Casseroles is a collection of over 500 casserole recipes. Everyone loves casseroles, and here you&#039;ll find plenty to satisfy everyone&#039;s taste - Beef, Lamb, Chicken, Turkey, Pork, Sausage, Seafood, Vegetable, and Fruit casseroles - all categorized with an easy-to-use, clickable table of contents. &lt;br/&gt;&lt;br/&gt;This cookbook is an excellent addition to your library or to have on your computer.&lt;br/&gt;', '2', 'IMG_229BAE-D09F91-8E0B8F-3B4A93-CEEDE9-6734DC.jpg', 'http://gogole.com', '', '', '', '200', '2011-07-21 22:37:10', '7', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('3', '10', 'Artisan Bread in Five Minutes', 'Artisan-Bread-in-Five-Minutes', '12.99', 'There&#039;s nothing like the smell of freshly baked bread to fill a kitchen with warmth, eager appetites, and endless praise for the baker who took on such a time-consuming task. Now, you can fill your kitchen with the irresistible aromas of a French bakery every day with just five minutes of active preparation time, and Artisan Bread in Five Minutes a Day will show you how.', '&lt;p&gt;There&rsquo;s nothing like the smell of freshly baked bread to fill a kitchen with warmth, eager appetites, and endless praise for the baker who took on such a time-consuming task. Now, you can fill your kitchen with the irresistible aromas of a French bakery every day with just five minutes of active preparation time, and &lt;em&gt;Artisan Bread in Five Minutes a Day&lt;/em&gt; will show you how.&lt;/p&gt;&lt;p&gt;Coauthors Jeff Hertzberg and Zo&euml; Fran&ccedil;ois prove that bread baking can be easier than a trip to the bakery. Their method is quick and simple, bringing forth scrumptious perfection in each loaf. Delectable creations will emerge straight from your own oven as warm, indulgent masterpieces that you can finally make for yourself. In exchange for a mere five minutes of your time, your breads will rival those of the finest bakers in the world.&lt;/p&gt;&lt;p&gt;With nearly 100 recipes to put this ingenious technique to use, &lt;em&gt;Artisan Bread in Five Minutes a Day&lt;/em&gt; will open the eyes of any potential baker who has sworn off homemade bread as simply too much work. Crusty baguettes, mouth-watering pizzas, hearty sandwich loaves, and even buttery pastries can easily become part of your own personal menu, and this innovative book will teach you everything you need to know.  &lt;/p&gt;', '3', 'IMG_CCF94C-6DE2E9-B63851-8F416B-4ED975-9221A9.jpg', '', '', '', '', '100', '2011-07-21 22:39:02', '3', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('4', '10', 'Artisan Breads Every Day', 'Artisan-Breads-Every-Day', '11.99', 'Peter Reinhart&#039;s Artisan Breads Every Day distills the renowned baking instructor&#039; s professional techniques down to the basics, delivering artisan bread recipes that anyone with flour and a fridge can make and bake with ease.', 'Peter Reinhart&#039;s Artisan Breads Every Day distills the renowned baking instructor&#039; s professional techniques down to the basics, delivering artisan bread recipes that anyone with flour and a fridge can make and bake with ease. &lt;p&gt;Reinhart begins with the simplest French bread, then moves on to familiar classics such as ciabatta, pizza dough, and soft sandwich loaves, and concludes with fresh specialty items like pretzels, crackers, croissants, and bagels. Each recipe is broken into &quot;Do Ahead&quot; and &quot;On Baking Day&quot; sections, making every step--from preparation through pulling pans from the oven&ndash;a breeze, whether you bought your loaf pan yesterday or decades ago. These doughs are engineered to work flawlessly for busy home bakers: most require only a straightforward mixing and overnight fermentation. The result is reliably superior flavor and texture on par with loaves from world-class artisan bakeries&ndash;and all with little hands-on time. &lt;/p&gt;&lt;p&gt;America&#039;s favorite baking instructor and innovator Peter Reinhart offers new time-saving techniques accompanied by full-color, step-by-step photos throughout so that in no time you&#039;ll be producing fresh batches of: &lt;br/&gt;&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Sourdough Baguettes &lt;/li&gt;&lt;li&gt;50% and 100% Whole Wheat Sandwich Loaves&lt;/li&gt;&lt;li&gt;Soft and Crusty Cheese Bread &lt;/li&gt;&lt;li&gt;English Muffins &lt;/li&gt;&lt;li&gt;Cinnamon Buns &lt;/li&gt;&lt;li&gt;Panettone &bull; Hoagie Rolls &lt;/li&gt;&lt;li&gt;Chocolate Cinnamon Babka &lt;/li&gt;&lt;li&gt;Fruit-Filled Thumbprint Rolls &lt;/li&gt;&lt;li&gt;Danish&lt;/li&gt;&lt;li&gt; Best-Ever Biscuits &lt;/li&gt;&lt;/ul&gt;', '4', 'IMG_F72CE2-FE3A1A-AFF5CC-A0DC64-73646F-688E5D.jpg', '', '', '', '', 'D15', '2011-07-21 22:40:47', '23', '2', '0', '29', '6', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('5', '12', 'Hello, Cupcake!', 'Hello-Cupcake', '9.99', 'America&#039;s favorite food photography team, responsible for the covers of America&#039;s top magazines, shows how to create funny, scary, and sophisticated masterpieces, using a zipper lock bag and common candies and snack items.With these easy-to-follow techniques, even the most kitchen-challenged cooks can', '&lt;p&gt;Witty, one-of-a-kind imaginative cupcake designs using candies from the local convenience store.&lt;/p&gt;&lt;p&gt;America&rsquo;s favorite food photography team, responsible for the covers of America&rsquo;s top magazines, shows how to create funny, scary, and sophisticated masterpieces, using a zipper lock bag and common candies and snack items.With these easy-to-follow techniques, even the most kitchen-challenged cooks can&lt;/p&gt;&lt;p&gt;&bull; raise a big-top circus cupcake tier for a kid&rsquo;s birthday &bull; plant candy vegetables on Oreo earth cupcakes for a garden party &bull; trot out a line of confectionery &ldquo;pupcakes&rdquo; for a dog fancier &bull; serve sausage and pepperoni pizza cupcakes for April Fool&rsquo;s Day &bull; bewitch trick-or-treaters with chilly ghost chocolate cupcakes &bull; create holidays on icing with turkey cupcake place cards, a white cupcake Christmas wreath, and Easter egg cupcakes&lt;/p&gt;&lt;p&gt;No baking skills or fancy pastry equipment is required. Spotting the familiar items in the hundreds of brilliant photos is at least half the fun.  &lt;/p&gt;', '5', 'IMG_8E69B0-DE3561-F02322-2E2600-BB885F-5F0B56.jpg', '', '', '', '', 'D25', '2011-07-21 22:44:38', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('6', '12', 'Betty Crocker Desserts', 'Betty-Crocker-Desserts', '9.99', 'You can do way more with Betty Crocker mixes than just make cakes and cupcakes, like Chocolate Mousse-Raspberry Cake, Southern Apple Crumble, Chocolate-Marshmallow Pillows, and Red Velvet Cupcakes with Cream Cheese Frosting. Delectable fresh-from-the-oven desserts are as easy as 1-2-3. Betty Crocker Fix-with-a-Mix Desserts provides easy recipes for making all kinds of moist and mouthwatering goodies-all fast and easy with a Betty Crocker mix', '&lt;p&gt;An incredible array of swoon-worthy sweets, all starting with a mix! &lt;/p&gt;&lt;p&gt;You can do way more with Betty Crocker mixes than just make cakes and cupcakes, like Chocolate Mousse-Raspberry Cake, Southern Apple Crumble, Chocolate-Marshmallow Pillows, and Red Velvet Cupcakes with Cream Cheese Frosting. Delectable fresh-from-the-oven desserts are as easy as 1-2-3. &lt;em&gt;Betty Crocker Fix-with-a-Mix Desserts &lt;/em&gt;provides easy recipes for making all kinds of moist and mouthwatering goodies-all fast and easy with a Betty Crocker mix. There&#039;s also a bonus chapter that shows you how to make great-tasting treats with Betty Crocker&#039;s new and incredibly popular line of gluten-free mixes.&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Includes 100 recipes with a luscious full-color photo of every recipe&lt;/li&gt;&lt;li&gt;All recipes start with Betty Crocker&#039;s trusted mixes, including SuperMoist&reg; Cake Mix, angel food cake mix, brownie mix, cookie mix, Bisquick&reg;, and all-new gluten-free mixes for cookies, brownies, and cakes&lt;/li&gt;&lt;li&gt;Accompanying sidebars offer creative ideas for decorating cupcakes, types of frosting for cookies, and special-occasion toppers for fruit desserts&lt;/li&gt;&lt;li&gt;A handy index by mix lets readers pick recipes based on the mixes they already have in their pantry&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;There&#039;s almost nothing you can&#039;t do with Betty Crocker&#039;s wide variety of dessert mixes. With &lt;em&gt;Betty Crocker Fix-with-a-Mix, &lt;/em&gt;you&#039;ll never run out of yummy options!  &lt;/p&gt;', '9', 'IMG_03B0DD-F700E9-F06C72-6628FF-B29E5D-B32194.jpg', '', '', '', '', '25', '2011-07-21 22:52:33', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('7', '12', 'The Cake Mix Doctor Returns', 'The-Cake-Mix-Doctor-Returns', '9.99', 'What could be better than a phenomenon? The return of a phenomenon. Ten years ago Anne Byrn&#039;s The Cake Mix Doctor began its extraordinary run as one of the most popular baking books of all time. Now Anne Byrn is back with the all-new Cake Mix Doctor Returns!', 'What could be better than a phenomenon? The return of a phenomenon. Ten years ago Anne Byrn&#039;s &lt;em&gt;The Cake Mix Doctor&lt;/em&gt; began its extraordinary run as one of the most popular baking books of all time. Now Anne Byrn is back with the all-new &lt;em&gt;Cake Mix Doctor Returns!&lt;/em&gt; From the beloved author who showed home bakers how adding a touch of sweet butter or a dusting of cocoa powder, a dollop of vanilla yogurt or flurry of grated lemon zest could transform the ordinary into the extraordinary. Here are 160 brand-new recipes&mdash;that&rsquo;s right, 160 amazing cake mix recipes&mdash;for luscious layer cakes, sheet cakes, brownies, bars, cookies, and more.&lt;p&gt;And the book is needed more than ever. Today 90 percent of home cooks use prepackaged mixes, while the economy is creating a perfect excuse to let them eat cake&mdash;cake equals happiness. And what cakes! 40 layer cakes, from Tiramisu Cake to The Best Red Velvet Cake, Strawberry Refrigerator Cake to Chocolate Swirled Cannoli Cake. 35 sheet cakes. 38 bundt and pound cakes. 16 cupcakes and muffins, plus the cult classic Whoopie Pie. And brownies, bars, and cookies, including Spice Drop Cookies, Angel Food Macaroons, and Chocolate Espresso Biscotti. There&#039;s even a wedding cake, a frequent request from the author&#039;s passionate online community.&lt;/p&gt;&lt;p&gt;The Cake Mix Doctor is back&mdash;just say ahhhhh!  &lt;/p&gt;', '9', 'IMG_D51BAF-D1701E-E3B2B9-3C895F-FD928B-61D0F3.jpg', '', '', '', '', '25', '2011-07-21 22:53:52', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('8', '11', 'The Beer Devotional', 'The-Beer-Devotional', '7.99', 'As Ben Franklin said, beer is a sign that God loves us and wants us to be happy. Now beer lovers everywhere can hoist a cold one while browsing this informative guide to their favorite beverage. For each day of the year, beer expert and homebrewer Jess Lebow lists a beer, information on its history, taste, price, and where to find it.', 'As Ben Franklin said, beer is a sign that God loves us and wants us to be happy. Now beer lovers everywhere can hoist a cold one while browsing this informative guide to their favorite beverage. For each day of the year, beer expert and homebrewer Jess Lebow lists a beer, information on its history, taste, price, and where to find it. He suggests food pairings and includes trivia, brewing tips, and information about beer-related events, as well as quotations about the ease and contentment beer brings to our lives. &lt;p&gt;Every state in the union is represented in this book, which unlocks the secrets of stouts, lembics, IPAs, and porters. The Beer Devotional offers you an inspirational daily guide to the joys of beer.  &lt;/p&gt;', '9', 'IMG_767F1D-DC58D8-FD7B49-E0B3E3-491BAC-7FD8A2.jpg', '', '', '', '', '10', '2011-07-21 22:57:15', '2', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('9', '11', 'The Billionaire&#039;s Vinegar', 'The-Billionaires-Vinegar', '12.99', 'It was the most expensive bottle of wine ever sold. In 1985, at a heated auction by Christie&#039;s of London, a 1787 bottle of Ch&acirc;teau Lafite Bordeaux&mdash;one of a cache of bottles unearthed in a bricked-up Paris cellar and supposedly owned by Thomas Jefferson&mdash;went for $156,000 to a member of the Forbes family.', 'It was the most expensive bottle of wine ever sold. In 1985, at a heated auction by Christie&rsquo;s of London, a 1787 bottle of Ch&acirc;teau Lafite Bordeaux&mdash;one of a cache of bottles unearthed in a bricked-up Paris cellar and supposedly owned by Thomas Jefferson&mdash;went for $156,000 to a member of the Forbes family. The discoverer of the bottle was pop-band manager turned wine collector Hardy Rodenstock, who had a knack for finding extremely old and exquisite wines. &lt;br/&gt;&lt;br/&gt;But rumors about the bottle soon arose. Why wouldn&rsquo;t Rodenstock reveal the exact location where it had been found? Was it part of a smuggled Nazi hoard? Or did his reticence conceal an even darker secret? It would take more than two decades for those questions to be answered and involve a gallery of intriguing players&mdash;among them Michael Broadbent, the bicycle-riding British auctioneer who speaks of wines as if they are women and staked his reputation on the record-setting sale; Serena Sutcliffe, Broadbent&rsquo;s elegant archrival, whose palate is covered by a hefty insurance policy; and Bill Koch, the extravagant Florida tycoon bent on exposing the truth about Rodenstock.  &lt;br/&gt;&lt;br/&gt;Pursuing the story from Monticello to London to Zurich to Munich and beyond, Benjamin Wallace also offers a mesmerizing history of wine, complete with vivid accounts of subterranean European laboratories where old vintages are dated and of Jefferson&rsquo;s colorful, wine-soaked days in France, where he... ', '8', 'IMG_61F641-EBA8C3-54FCC3-AF2D93-DD4453-07E845.jpg', '', '', '', '', '15', '2011-07-21 22:58:36', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('10', '4', 'Cookouts Veggie Style', 'Cookouts-Veggie-Style', '8.99', 'Sounds like the perfect all-American cookout--unless you&#039;re a vegetarian. With more people adopting a mainly vegetarian diet, the choices might seem limited for all those great outdoor parties. Whether it&#039;s a barbecue or a picnic in the park, it&#039;s time to get creative with meatless summer meals! Inside are mouthwatering recipes', '&lt;em&gt;Hamburgers, hot dogs, and barbecue ribs.&lt;/em&gt;&lt;p&gt;Sounds like the perfect all-American cookout--unless you&#039;re a vegetarian. With more people adopting a mainly vegetarian diet, the choices might seem limited for all those great outdoor parties. Whether it&#039;s a barbecue or a picnic in the park, it&#039;s time to get creative with meatless summer meals! Inside are mouthwatering recipes such as:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Grilled Seitan with Apple Salsa&lt;/li&gt;&lt;li&gt;Creole Slaw&lt;/li&gt;&lt;li&gt;Grilled Eggplant Panini&lt;/li&gt;&lt;li&gt;Halloumi Skewers with Parsley &amp;amp; Lemon Salsa&lt;/li&gt;&lt;li&gt;Barley Burgers on Rye Bread&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;Forget boring Boca burgers and bland pasta salad! This book shows you how to make delicious, unique, and fresh vegetarian meals so you&#039;ll never miss the burgers and dogs again!  &lt;/p&gt;', '7', 'IMG_14B242-66347D-C37C16-9B90CB-C09A3E-6A2EB6.jpg', '', '', '', '', 'D10', '2011-07-21 23:02:53', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('11', '4', 'Forks Over Knives', 'Forks-Over-Knives', '6.99', 'For decades, that question has fascinated a small circle of impassioned doctors and researchers&mdash;and now, their life-changing research is making headlines in the hit documentary Forks Over Knives. Their answer? Eat a whole-foods, plant-based diet&mdash;it could save your life.', '&lt;strong&gt;What if one simple change could save you from heart disease, diabetes, and cancer?&lt;/strong&gt;&lt;p&gt; &lt;/p&gt;&lt;p&gt;For decades, that question has fascinated a small circle of impassioned doctors and researchers&mdash;and now, their life-changing research is making headlines in the hit documentary &lt;em&gt;Forks Over Knives&lt;/em&gt;. Their answer? Eat a whole-foods, plant-based diet&mdash;it could save your life.&lt;/p&gt;&lt;p&gt;It may overturn most of the diet advice you&rsquo;ve heard&mdash;but the experts behind &lt;em&gt;Forks Over Knives&lt;/em&gt; aren&#039;t afraid to make waves. In his book &lt;em&gt;Prevent and Reverse Heart Disease&lt;/em&gt;, Dr. Caldwell Esselstyn explained that eating meat, dairy, and oils injures the lining of our blood vessels, causing heart disease, heart attack, or stroke. In &lt;em&gt;The China Study&lt;/em&gt;, Dr. Colin Campbell revealed how cancer and other diseases skyrocket when eating meat and dairy is the norm&mdash;and plummet when a traditional plant-based diet persists. And more and more experts are adding their voices to the cause: There is nothing else you can do for your health that can match the benefits of a plant-based diet.&lt;/p&gt;&lt;p&gt;Now, as &lt;em&gt;Forks Over Knives&lt;/em&gt; is introducing more people than ever before to the plant-based way to health, this accessible guide provides the information you need to adopt and maintain a plant-based diet. Features include:&lt;/p&gt;&lt;p&gt; &lt;/p&gt;&lt;ul&gt;&lt;li&gt;Insights from the &lt;strong&gt;luminaries behind the film&lt;/strong&gt;&mdash;Dr. Neal Barnard, Dr. John McDougall, The Engine 2 Diet author Rip Esselstyn, and many others&lt;/li&gt;&lt;li&gt;&lt;strong&gt;Success stories&lt;/strong&gt; from converts to plant-based eating&mdash;like San&rsquo;Dera Prude, who no longer needs to medicate her diabetes, has lost weight, and feels great!&lt;/li&gt;&lt;li&gt;The many &lt;strong&gt;benefits of a whole-foods, plant-based diet&lt;/strong&gt;&mdash;for you, for animals and the environment, and for our future&lt;/li&gt;&lt;li&gt;A helpful primer on crafting a healthy diet rich in unprocessed fruits, vegetables, legumes, and whole grains, including &lt;strong&gt;tips on transitioning&lt;/strong&gt; and essential kitchen tools&lt;/li&gt;&lt;li&gt;&lt;strong&gt;125 recipes&lt;/strong&gt; from 25 champions of plant-based dining&mdash;from Blueberry Oat Breakfast Muffins and Sunny Orange Yam Bisque to Garlic Rosemary Polenta and Raspberry-Pear Crisp&mdash;delicious, healthy, and for every meal, every day.&lt;/li&gt;&lt;/ul&gt;', '6', 'IMG_6EDE94-2AEB78-D3CDE8-9F8EF1-52186F-95B195.jpg', '', '', '', '', '10', '2011-07-21 23:04:03', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('12', '4', 'Becoming Vegetarian', 'Becoming-Vegetarian', '6.99', 'The evidence is in -  millions of people are moving toward a vegetarian diet because it offers a healthful and environmentally sound alternative to the standard diet. Becoming Vegetarian is the ultimate source for making this valuable and beneficial life change.', 'The evidence is in -&amp;nbsp; millions of people are moving toward a vegetarian diet because it offers a healthful and environmentally sound alternative to the standard diet. &lt;em&gt;Becoming Vegetarian&lt;/em&gt; is the ultimate source for making this valuable and beneficial life change. Packed with authoritative vegetarian and vegan nutrition information from established and savvy experts, this powerful book takes the worry out of making an important, healthy transition.&lt;br/&gt;&lt;p&gt;Here&#039; what&#039;s inside:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;Vegetarian food guide for optimal nutrition and easy meal planning&lt;/li&gt;&lt;li&gt;Delicious, easy recipes&lt;/li&gt;&lt;li&gt;Helpful guidelines for those who are just starting out&lt;/li&gt;&lt;li&gt;Cutting edge scientific information for experienced vegetarians&lt;/li&gt;&lt;li&gt;Nutrition essentials from infancy through our senior years&lt;/li&gt;&lt;li&gt;Practical tips for weight control&lt;/li&gt;&lt;li&gt;Much, much more&lt;/li&gt;&lt;/ul&gt;This comprehensive update of an international bestseller is the one resource that contains everything you need to know about becoming a vegetarian or fine-tuning a vegetarian diet. From dealing with awkward social situations to making sure you&#039;re getting all the necessary nutrients, let &lt;em&gt;Vesanto Melina&lt;/em&gt; and &lt;em&gt;Brenda Davis&lt;/em&gt; give you the information you need to achieve a healthful vegetarian life with ease. Change the way you look at food and your health forever&mdash; start following the dynamic, easy-to-implement advice in &lt;em&gt;Becoming Vegetarian&lt;/em&gt; today.  ', '12', 'IMG_42130F-65AA04-153A36-A35B1E-2D4E6B-753C59.jpg', '', '', '', '', '25', '2011-07-21 23:05:29', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('13', '2', 'A Dance with Dragons', 'A-Dance-with-Dragons', '16.99', 'Dubbed &quot;the American Tolkien&quot; by Time magazine, George R. R. Martin has earned international acclaim for his monumental cycle of epic fantasy. Now the #1 New York Times bestselling author delivers the fifth book in his landmark series&mdash;as both familiar faces and surprising new forces vie for a foothold in a fragmented empire.', '&lt;p&gt;Dubbed &ldquo;the American Tolkien&rdquo; by &lt;em&gt;Time&lt;/em&gt; magazine, George R. R. Martin has earned international acclaim for his monumental cycle of epic fantasy. Now the #1 &lt;em&gt;New York Times&lt;/em&gt; bestselling author delivers the fifth book in his landmark series&mdash;as both familiar faces and surprising new forces vie for a foothold in a fragmented empire. &lt;br/&gt; &lt;br/&gt;&lt;strong&gt;A Dance With Dragons: A Song of Ice and Fire: Book Five &lt;/strong&gt;&lt;/p&gt;&lt;p&gt;In the aftermath of a colossal battle, the future of the Seven Kingdoms hangs in the balance&mdash;beset by newly emerging threats from every direction. In the east, Daenerys Targaryen, the last scion of House Targaryen, rules with her three dragons as queen of a city built on dust and death. But Daenerys has thousands of enemies, and many have set out to find her. As they gather, one young man embarks upon his own quest for the queen, with an entirely different goal in mind.&lt;/p&gt;&lt;p&gt;Fleeing from Westeros with a price on his head, Tyrion Lannister, too, is making his way to Daenerys. But his newest allies in this quest are not the rag-tag band they seem, and at their heart lies one who could undo Daenerys&rsquo;s claim to Westeros forever.&lt;/p&gt;&lt;p&gt;Meanwhile, to the north lies the mammoth Wall of ice and stone&mdash;a structure only as strong as those guarding it. There, Jon Snow, 998th Lord Commander of the Night&rsquo;s Watch, will face his greatest challenge. For he has powerful foes not only within the Watch but also beyond, in the land of the creatures of ice.&lt;/p&gt;&lt;p&gt;From all corners, bitter conflicts reignite, intimate betrayals are perpetrated, and a grand cast of outlaws and priests, soldiers and skinchangers, nobles and slaves, will face seemingly insurmountable obstacles. Some will fail, others will grow in the strength of darkness. But in a time of rising restlessness, the tides of destiny and politics will lead inevitably to the greatest dance of all.  &lt;/p&gt;', '6', 'IMG_689883-F6A270-309C28-62482D-9C70EC-CD2EEC.jpg', '', '', '', '', '40', '2011-07-21 23:07:17', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('14', '2', 'No Rest for the Dead', 'No-Rest-for-the-Dead', '16.99', 'More than twenty New York Times bestselling authors team up to create a first-rate serial novel -- a collaboration that combines the skills of America&rsquo;s greatest storytellers to produce a gripping, spellbinding mystery.', '&lt;p&gt;&lt;strong&gt;Alexander McCall Smith. Sandra Brown. Faye Kellerman. J.A. Jance. Jeffery Deaver. Kathy Reichs. Lisa Scottoline. Jeff Lindsay. &lt;/strong&gt;These are only a handful of the names that&lt;strong&gt; &lt;/strong&gt;make up the all-star lineup of authors behind&lt;strong&gt; &lt;/strong&gt;&lt;em&gt;No Rest for the Dead&lt;/em&gt;, a tale of&lt;strong&gt; &lt;/strong&gt;vengeance, greed, and love that flows seamlessly,&lt;strong&gt; &lt;/strong&gt;in the words of David Baldacci, &ldquo;as it passes from&lt;strong&gt; &lt;/strong&gt;one creator&#039;s mind to the next.&rdquo;&lt;/p&gt;&lt;p&gt;When\r\n Christopher Thomas, a ruthless curator at San Francisco&rsquo;s McFall Art \r\nMuseum, is murdered and his decaying body is found in an iron maiden in a\r\n Berlin museum, his wife, Rosemary, is the primary suspect, and she is \r\ntried, convicted and executed. Ten years later, Jon Nunn, the detective \r\nwho cracked the case, is convinced that the wrong person was put to \r\ndeath. In the years since the case was closed, he&#039;s discovered a web of \r\ndeceit and betrayal surrounding the Thomases that could implicate any \r\nnumber of people in the crime. With the help of the dead woman&#039;s friend,\r\n he plans to gather everyone who was there the night Christopher died \r\nand finally uncover the truth, suspect by suspect. Solving this case may\r\n be Nunn&rsquo;s last chance for redemption &hellip; but the shadowy forces behind \r\nChristopher&rsquo;s death will stop at nothing to silence the past forever. &lt;/p&gt;&lt;p&gt;In\r\n this innovative storytelling approach, each of these twenty-five \r\nbestselling writers brings their distinctive voice to a chapter of the \r\nnarrative, building the tension to a shocking, explosive finale. &lt;em&gt;No Rest&lt;/em&gt; &lt;em&gt;for the Dead &lt;/em&gt;is a thrilling, page-turning accomplishment that only America&rsquo;s very best authors could achieve. &lt;/p&gt;&lt;p&gt;From the Introduction of &lt;em&gt;No Rest for the Dead&lt;/em&gt;:&lt;/p&gt;&lt;p&gt;&lt;i&gt;There\r\n is always that case, the one that keeps me awake at night, the one that\r\n got away. It&rsquo;ll always be there, gnawing at the edges of my mind. It \r\ndoesn&rsquo;t matter that ten years have passed, it doesn&rsquo;t matter that the \r\ncase is officially closed. An innocent woman was executed, I was the one\r\n who helped make it happen, and on the sad night when the needle was \r\ninserted into her arm, injecting her with death, part of my life ended \r\ntoo.&lt;/i&gt;&lt;/p&gt;', '6', 'IMG_CC3B68-459651-409C44-6D5440-6AD94F-D88BDF.jpg', '', '', '', '', '40', '2011-07-21 23:09:18', '5', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('15', '2', 'Mile 81', 'Mile-81', '2.99', 'Mile 81 is a boarded up rest stop on a highway in Maine. It&#039;s a place where high school kids drink and get into the kind of trouble high school kids have always gotten into. It&#039;s the place where Pete Simmons goes when his older brother, who&#039;s supposed to be looking out for him, heads off to the gravel pit to play &quot;paratroopers over the side.&quot; Pete, armed only with the magnifying glass he got for his tenth birthday, finds a discarded bottle of vodka in the boarded up burger shack and drinks enough to pass out.', 'Mile 81 is a boarded up rest stop on a highway in Maine. It&#039;s a place where high school kids drink and get into the kind of trouble high school kids have always gotten into. It&#039;s the place where Pete Simmons goes when his older brother, who&#039;s supposed to be looking out for him, heads off to the gravel pit to play &quot;paratroopers over the side.&quot; Pete, armed only with the magnifying glass he got for his tenth birthday, finds a discarded bottle of vodka in the boarded up burger shack and drinks enough to pass out.&lt;p&gt;Not much later, a mud-covered station wagon (which is strange because there hadn&#039;t been any rain in New England for over a week) veers into the Mile 81 rest area, ignoring the sign that says &quot;closed, no services.&quot; The driver&#039;s door opens but nobody gets out.&lt;/p&gt;&lt;p&gt;Doug Clayton, an insurance man from Bangor, is driving his Prius to a conference in Portland. On the backseat are his briefcase and suitcase and in the passenger bucket is a King James Bible, what Doug calls &quot;the ultimate insurance manual,&quot; but it isn&#039;t going to save Doug when he decides to be the Good Samaritan and help the guy in the broken down wagon. He pulls up behind it, puts on his four-ways, and then notices that the wagon has no plates.&lt;/p&gt;&lt;p&gt;Ten minutes later, Julianne Vernon, pulling a horse trailer, spots the Prius and the wagon, and pulls over. Julianne finds Doug Clayton&#039;s cracked cell phone near the wagon door - and gets too close herself. By the time Pete Simmons wakes up from his vodka nap, there are a half a dozen cars at the Mile 81 rest stop. Two kids - Rachel and Blake Lussier - and one horse named Deedee are the only living left. Unless you maybe count the wagon.&lt;/p&gt;&lt;p&gt;With the heart of &lt;em&gt;Stand By Me&lt;/em&gt; and the genius horror of &lt;em&gt;Christine&lt;/em&gt;, &lt;em&gt;Mile 81&lt;/em&gt; is Stephen King unleashing his imagination as he drives past one of those road signs...  &lt;/p&gt;', '1', 'IMG_B4BC5A-35C5DA-A1BD81-61A80B-656CF9-7096B5.jpg', '', '', '', '', '50', '2011-07-21 23:11:04', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('16', '14', 'Metamorphosis', 'Metamorphosis', '1.99', 'A man wakes up one day to find he has been changed into a large insect/beetle. The story follows his efforts to deal with this, and his family&#039;s reaction to the change. But it&#039;s not just a story about a man turning into a beetle, it&#039;s a clever way of writing about how a family would deal with the main breadwinner in the house becoming unable to work, and also on a wider scope', 'A man wakes up one day to find he has been changed into a large insect/beetle. The story follows his efforts to deal with this, and his family&#039;s reaction to the change. But it&#039;s not just a story about a man turning into a beetle, it&#039;s a clever way of writing about how a family would deal with the main breadwinner in the house becoming unable to work, and also on a wider scope, the way a family (and the world at large) reacts to someone who is disabled, or terminally ill.&lt;br/&gt;&lt;br/&gt;It could also be an analogy for how a family treats a member of the family who is now old and needs to be cared for. The man who is now a beetle, is forced to live in his room, shut away from the world, for fear that he will frighten anyone who enters the house.&lt;br/&gt;&lt;br/&gt;The man who once provided for the family, and thought of them above himself, has now become a burden on them, as they are now short of money, and have to find employment. The once able and hard-working man, transformed into a beetle, is now rejected, and his family blame him for their financial situation and the fact that they cannot move to a smaller house, because they need to have a room to keep him in.&lt;br/&gt;&lt;br/&gt;The descriptive quality of the writing is excellent, and although it is a sad and gruesome tale, it is also very funny in parts; I couldn&#039;t help laughing out loud a couple of times.&lt;br/&gt;&lt;br/&gt;The main thing that struck me, was that even though this story is nearly 100 years old, it is still totally relevant to today&#039;s world (and I&#039;m not sure that&#039;s something we should be proud of).', '12', 'IMG_3E3A24-62385B-F295BF-6E8646-24BEF9-2E322A.jpg', '', '', '', '', '50', '2011-07-22 10:57:06', '2', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('17', '13', 'Full Dark, No Stars', 'Full-Dark-No-Stars', '6.99', 'The one thing nobody asked in casual conversation, Darcy thought in the days after she found what she found in the garage, was this: How&#039;s your marriage?They asked how was your weekend and how was your trip to Florida and how&#039;s your health and how are the kids; they even asked how&#039;s life been treatin you, hon?', 'The one thing nobody asked in casual conversation, Darcy thought in the days after she found what she found in the garage, was this: How’s your marriage?They asked how was your weekend and how was your trip to Florida and how’s your health and how are the kids; they even asked how’s life been treatin you, hon? But nobody asked how’s your marriage?&lt;br/&gt;&lt;br/&gt;Good, she would have answered the question before that night. Everything’s fine.&lt;br/&gt;&lt;br/&gt;She had been born Darcellen Madsen (Darcellen, a name only parents besotted with a freshly purchased book of baby names could love), in the year John F. Kennedy was elected President. She was raised in Freeport, Maine, back when it was a town instead of an adjunct to L.L.Bean, America’s first superstore, and half a dozen other oversized retail operations of the sort that are called “outlets” (as if they were sewer drains rather than shopping locations). &lt;br/&gt;&lt;br/&gt;She went to Freeport High School, and then to Addison Business School, where she learned secretarial skills. She was hired by Joe Ransome Chevrolet, which by 1984, when she left the company, was the largest car dealership in Portland. She was plain, but with the help of two marginally more sophisticated girlfriends, learned enough makeup skills to make herself pretty on workdays and downright eye-catching on Friday and Saturday nights, when a bunch of them liked to go out for margaritas at The Lighthouse or Mexican Mike’s (where there was live music).', '11', 'IMG_B01988-F44B7F-6F8E8A-A4025E-AD5756-BDF457.jpg', '', '', '', '', 'D50', '2011-07-22 11:00:00', '4', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('18', '15', 'The Duke And I with Bonus Material', 'The-Duke-And-I-with-Bonus-Material', '1.49', 'Simon Basset, the irresistible Duke of Hastings, has hatched a plan to keep himself free from the town&#039;s marriage-minded society mothers. He pretends to be engaged to the lovely Daphne Bridgerton.', 'Simon Basset, the irresistible Duke of Hastings, has hatched a plan to keep himself free from the town&#039;s marriage-minded society mothers. He pretends to be engaged to the lovely Daphne Bridgerton. After all, it isn&#039;t as if the brooding rogue has any real plans to marry - though there is something about the alluring Miss Bridgerton that sets Simon&#039;s heart beating a bit faster.&lt;br/&gt;&lt;br/&gt;And as for Daphne, surely the clever debutante will attract some very worthy suitors now that it seems a duke has declared her desirable. But as Daphne waltzes across ballroom after ballroom with Simon, she soon forgets that their courtship is a complete sham.&lt;br/&gt;&lt;br/&gt;And now she has to do the impossible and keep herself from losing her heart and soul completely to the handsome hell-raiser who has sworn off marriage forever!', '12', 'IMG_F46092-52A4FE-B83465-6954C6-2D64B6-759719.jpg', '', '', '', '', 'D10', '2011-07-22 11:02:10', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('19', '15', 'Spying in High Heels', 'Spying-in-High-Heels', '0.49', 'Simon Basset, the irresistible Duke of Hastings, has hatched a plan to keep himself free from the town&#039;s marriage-minded society mothers. He pretends to be engaged to the lovely Daphne Bridgerton.', 'L.A. shoe designer, Maddie Springer, lives her life by three rules: Fashion. Fashion. Fashion. But when she stumbles upon the work of a brutal killer, her life takes an unexpected turn from Manolos to murder.&lt;br/&gt;&lt;br/&gt;And things only get worse when her boyfriend disappears - along with $20 million in embezzled funds - and her every move is suddenly under scrutiny by the LAPD&#039;s sexiest cop.&lt;br/&gt;&lt;br/&gt;With the help of her post-menopausal bridezilla of a mother, a 300 pound psychic and one seriously oversexed best friend, Maddie finds herself stepping out of her stilettos and onto the trail of a murderer. But can she catch a killer before the killer catches up to her...&lt;br/&gt;***BONUS MATERIAL*** Maddie&rsquo;s Guide to Essential Footwear for the Stylish Crime Fighter &amp;amp; &quot;Behind the Book&quot; Author Interview.', '11', 'IMG_1A7BBB-8701DF-2DF240-E6AB90-31F2AE-5DF190.jpg', '', '', '', '', '10', '2011-07-22 11:03:33', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('20', '16', 'Conquistadora', 'Conquistadora', '12.99', 'As a young girl growing up in Spain, Ana Larragoity Cubillas is powerfully drawn to Puerto Rico by the diaries of an ancestor who traveled there with Ponce de Le&oacute;n. And in handsome twin brothers Ram&oacute;n and Inocente&mdash;both in love with Ana&mdash;she finds a way to get there.', '&lt;p&gt;An epic novel of love, discovery, and adventure by the author of the best-selling memoir&amp;nbsp;&lt;em&gt;When I Was Puerto Rican.&lt;br/&gt;\r\n  &lt;/em&gt;&lt;br/&gt;\r\n  As a young girl growing up in Spain, Ana Larragoity Cubillas is powerfully drawn to Puerto Rico by the diaries of an ancestor who traveled there with Ponce de Le&oacute;n. And in handsome twin brothers Ram&oacute;n and Inocente&mdash;both in love with Ana&mdash;she finds a way to get there. She marries Ram&oacute;n, and in 1844, just eighteen, she travels across the ocean to a remote sugar plantation the brothers have inherited on the island.&lt;/p&gt;\r\n&lt;p&gt;Ana faces unrelenting heat, disease and isolation, and the dangers of the untamed countryside even as she relishes the challenge of running Hacienda los Gemelos. But when the Civil War breaks out in the United States,&amp;nbsp;Ana finds her livelihood, and perhaps even her life, threatened by the very people on whose backs her wealth has been built: the hacienda&rsquo;s slaves, whose richly drawn stories unfold alongside her own. And when at last Ana falls for a man who may be her destiny&mdash;a once-forbidden love&mdash;she will sacrifice nearly everything to keep hold of the land that has become her true home.&lt;/p&gt;\r\n&lt;p&gt;This is a sensual, riveting tale, set in a place where human passions and cruelties collide: thrilling history that has never before been brought so vividly and unforgettably to life.&lt;/p&gt;', '10', 'IMG_4F2582-BAC5F7-C82AB2-8BB2B5-E68317-6D673B.jpg', '', '', '', '', '20', '2011-07-22 11:04:56', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('21', '3', 'Bossypants', 'Bossypants', '12.99', 'Before Liz Lemon, before &quot;Weekend Update,&quot; before &quot;Sarah Palin,&quot; Tina Fey was just a young girl with a dream: a recurring stress dream that she was being chased through a local airport by her middle-school gym teacher. She also had a dream that one day she would be a comedian on TV.', '&lt;p&gt;Before Liz Lemon, before &quot;Weekend Update,&quot; before &quot;Sarah Palin,&quot; Tina Fey was just a young girl with a dream: a recurring stress dream that she was being chased through a local airport by her middle-school gym teacher. She also had a dream that one day she would be a comedian on TV.&lt;/p&gt;\r\n&lt;p&gt;She has seen both these dreams come true.&lt;/p&gt;\r\n&lt;p&gt;At last, Tina Fey&#039;s story can be told. From her youthful days as a vicious nerd to her tour of duty on&amp;nbsp;&lt;em&gt;Saturday Night Live&lt;/em&gt;; from her passionately halfhearted pursuit of physical beauty to her life as a mother eating things off the floor; from her one-sided college romance to her nearly fatal honeymoon -- from the beginning of this paragraph to this final sentence.&lt;/p&gt;\r\n&lt;p&gt;Tina Fey reveals all, and proves what we&#039;ve all suspected: you&#039;re no one until someone calls you bossy.&lt;/p&gt;\r\n&lt;p&gt;(&lt;em&gt;Includes Special, Never-Before-Solicited Opinions on Breastfeeding, Princesses, Photoshop, the Electoral Process, and Italian Rum Cake!)&lt;/em&gt;&lt;/p&gt;', '9', 'IMG_044B62-13BFD8-A7CC30-116E0F-744A1C-84D1E6.jpg', '', '', '', '', 'D20', '2011-07-22 11:06:21', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('22', '3', 'Does the Noise in My Head Bother You?', 'Does-the-Noise-in-My-Head-Bother-You', '12.99', '&quot;I&#039;ve been mythicized, Mick-icized, eulogized and fooligized, I&#039;ve been Cole-Portered and farmer&#039;s-daughtered, I&#039;ve been Led Zepped and 12-stepped. I&#039;m a rhyming fool and so cool that me, Fritz the Cat, and Mohair Sam are the baddest cats that am. I have so many outrageous stories, too many', '&lt;p&gt;&quot;I&#039;ve been mythicized, Mick-icized, eulogized and fooligized, I&#039;ve been Cole-Portered and farmer&#039;s-daughtered, I&#039;ve been Led Zepped and 12-stepped. I&#039;m a rhyming fool and so cool that me, Fritz the Cat, and Mohair Sam are the baddest cats that am. I have so many outrageous stories, too many, and I&#039;m gonna tell &#039;em all. All the unexpurgated, brain-jangling tales of debauchery, sex &amp;amp; drugs, transcendence &amp;amp; chemical dependence you will ever want to hear.&quot;&lt;/p&gt;\r\n&lt;p&gt;The son of a classical pianist straight out of the Bronx of old Archie comics, Steven Tyler was born to be a rock star. Weaned on Cole Porter, Nat King Cole, Mick&mdash;and his beloved Janis Joplin&mdash;Tyler began tearing up the streets and the stage as a teenager before finally meeting his &quot;mutant twin&quot; and legendary partner Joe Perry. In this addictively readable memoir, told in the playful, poetic voice that is uniquely his own, Tyler unabashedly recounts the meteoric rise, fall, and rise of Aerosmith over the last three decades and riffs on the music that gives it all meaning.&lt;/p&gt;\r\n&lt;p&gt;Tyler tells what it&#039;s like to be a living legend and the frontman of one of the world&#039;s most revered and infamous bands&mdash;the debauchery, the money, the notoriety, the fights, the motels and hotels, the elevators, limos, buses and jets, the rehab. He reveals the spiritual side that &quot;gets lost behind the stereotype of the Sex Guy, the Drug Guy, the Demon of Screamin&#039;, the Terror of the Tropicana.&quot; And he talks about his epic romantic life and his relationship with his four children. As dazzling, bold, and out-on-the-edge as the man himself,&amp;nbsp;&lt;em&gt;Does the Noise in My Head Bother You?&lt;/em&gt;&amp;nbsp;is an all-access backstage pass into this extraordinary showman&#039;s life.&lt;/p&gt;\r\n', '5', 'IMG_031418-4BF800-9B162B-AD9E56-A8C942-26DF25.jpg', '', '', '', '', 'D20', '2011-07-22 11:07:28', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('23', '5', 'How to Make Your Photos Look Like the Pros', 'How-to-Make-Your-Photos-Look-Like-the-Pros', '8.99', 'Scott Kelby, the man who changed the &quot;digital darkroom&quot; forever with his groundbreaking, #1 bestselling, award-winning book The Photoshop Book for Digital Photographers, now tackles the most important side of digital photography&mdash;how to take pro-quality shots using the same tricks today&#039;s top digital pros use (and it&#039;s easier than you&#039;d think).', '&lt;p&gt;Scott Kelby, the man who changed the &quot;digital darkroom&quot; forever with his groundbreaking, #1 bestselling, award-winning book The Photoshop Book for Digital Photographers, now tackles the most important side of digital photography&mdash;how to take pro-quality shots using the same tricks today&#039;s top digital pros use (and it&#039;s easier than you&#039;d think).&lt;/p&gt;\r\n&lt;p&gt;This entire book is written with a brilliant premise, and here&rsquo;s how Scott describes it: &quot;If you and I were out on a shoot, and you asked me, &#039;Hey, how do I get this flower to be in focus, but I want the background out of focus?&#039; I wouldn&#039;t stand there and give you a lecture about aperture, exposure, and depth of field. In real life, I&#039;d just say, &#039;Get out your telephoto lens, set your f/stop to f/2.8, focus on the flower, and fire away.&#039; You d say, &#039;OK,&#039; and you&#039;d get the shot. That&#039;s what this book is all about. A book of you and I shooting, and I answer the questions, give you advice, and share the secrets I&#039;ve learned just like I would with a friend, without all the technical explanations and without all the techno-photo-speak.&quot;&lt;/p&gt;\r\n&lt;p&gt;This isn&#039;t a book of theory&mdash;it isn&#039;t full of confusing jargon and detailed concepts: this is a book of which button to push, which setting to use, when to use them, and nearly two hundred of the most closely guarded photographic &quot;tricks of the trade&quot; to get you shooting dramatically better-looking, sharper, more colorful, more professional-looking photos with your digital camera every time you press the shutter button.&lt;/p&gt;\r\n&lt;p&gt;Here&#039;s another thing that makes this book different: each page covers just one trick, just one single concept that makes your photography better. Every time you turn the page, you&#039;ll learn another pro setting, another pro tool, another pro trick to transform your work from snapshots into gallery prints. There&#039;s never been a book like it, and if you&#039;re tired of taking shots that look &quot;OK,&quot; and if you&rsquo;re tired of looking in photography magazines and thinking, &quot;Why don&#039;t my shots look like that?&quot; then this is the book for you.&lt;/p&gt;', '4', 'IMG_905208-29C9ED-A773FD-5D7AE8-6AF938-62B87F.jpg', '', '', '', '', 'D20', '2011-07-22 11:09:18', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('24', '5', 'Android Development For Dummies', 'Android-Development-For-Dummies', '16.99', 'Even if you&#039;ve never written a mobile application, this book has the know-how you need to turn your great ideas into cool apps for the Android platform. With millions of smartphone users and a cornucopia of carriers, Android is a great place to ply the app development trade.', '&lt;p&gt;Even if you&#039;ve never written a mobile application, this book has the know-how you need to turn your great ideas into cool apps for the Android platform. With millions of smartphone users and a cornucopia of carriers, Android is a great place to ply the app development trade. This book shows you from the ground up how to set up your environment and create an app. Read on to become an Android developer extraordinaire!&lt;/p&gt;\r\n&lt;ul&gt;\r\n  &lt;li&gt;Welcome to Android &mdash; learn what makes a great Android app, how to use the SDK, ways to work with mobile screens, and how the development process works&lt;/li&gt;\r\n  &lt;li&gt;Make users happy &mdash; find out how to design an interface that mobile users will love&lt;/li&gt;\r\n  &lt;li&gt;Learn the code &mdash; work with the activity lifecycle and Android framework classes, use the Eclipse debugger, and create a home screen widget for your app&lt;/li&gt;\r\n  &lt;li&gt;Beyond the basics &mdash; take your skills up a notch with apps that involve SQLite databases and multiple screens&lt;/li&gt;\r\n  &lt;li&gt;Price and publish &mdash; pick the right price for your app and get it into the Android Market&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;Open the book and find:&lt;/p&gt;\r\n&lt;ul&gt;\r\n  &lt;li&gt;Cool ways to use the accelerometer in your app&lt;/li&gt;\r\n  &lt;li&gt;How to turn mobile limitations into opportunities&lt;/li&gt;\r\n  &lt;li&gt;Tips on installing and setting up the tools&lt;/li&gt;\r\n  &lt;li&gt;Step-by-step coding directions&lt;/li&gt;\r\n  &lt;li&gt;Ways to make your apps more marketable&lt;/li&gt;\r\n  &lt;li&gt;How to create really useful menus&lt;/li&gt;\r\n  &lt;li&gt;Advice on app pricing&lt;/li&gt;\r\n  &lt;li&gt;Ten great sample apps and SDKs, including code&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;Learn to:&lt;/p&gt;\r\n&lt;ul&gt;\r\n  &lt;li&gt;Create apps for hot smartphones like Droid X, Galaxy S, and MyTouch&lt;/li&gt;\r\n  &lt;li&gt;Download the SDK and get Eclipse up and running&lt;/li&gt;\r\n  &lt;li&gt;Code Android applications&lt;/li&gt;\r\n  &lt;li&gt;Submit your apps to the Android Market&lt;/li&gt;\r\n&lt;/ul&gt;', '3', 'IMG_6F09A8-7BB651-894B0D-B14DBA-449216-4EDB89.jpg', '', '', '', '', '20', '2011-07-22 11:10:49', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('25', '5', 'Windows 7 For Dummies', 'Windows-7-For-Dummies', '16.99', 'Windows For Dummies is the all-time bestselling guide to the Windows operating system. Windows 7 For Dummies answers all your questions about the interface adjustments and all the new tools in Windows 7.', '&lt;p&gt;The perfect plain-English guide to the much-anticipated release of Windows 7&lt;/p&gt;\r\n&lt;p&gt;&lt;em&gt;Windows For Dummies&lt;/em&gt;&amp;nbsp;is the all-time bestselling guide to the Windows operating system.&amp;nbsp;&lt;em&gt;Windows 7 For Dummies&lt;/em&gt;&amp;nbsp;answers all your questions about the interface adjustments and all the new tools in Windows 7.&lt;/p&gt;\r\n&lt;p&gt;Whether you&#039;re new to computers or just eager to start using the newest version of Windows, expert author Andy Rathbone will walk you step by step through the most common Windows 7 tasks, including managing files, applications, media, and Internet access. If you&#039;ve never used Windows before, it shows you the things most books assume you already know, like how to navigate the interface, customize the desktop, and work with the file system. Then it helps you get comfortable using all aspects of Windows 7.&lt;/p&gt;\r\n&lt;ul&gt;\r\n  &lt;li&gt;Nearly ninety percent of the world&#039;s PCs use the Windows operating system&lt;/li&gt;\r\n  &lt;li&gt;Covers basic management of applications, files, and data; creating and printing documents; setting up an Internet connection and e-mail account; and online security&lt;/li&gt;\r\n  &lt;li&gt;Explores using Windows to edit and manage audio, video, and photo files, and how to create CDs, DVDs, and playlists with Media Center&lt;/li&gt;\r\n  &lt;li&gt;Helps you tweak and customize Windows 7 to operate your way and set up user accounts, build a home network, and maintain your PC&lt;/li&gt;\r\n  &lt;li&gt;Provides troubleshooting advice, helps you find missing files and use the Help system, and explains common error messages&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;&lt;em&gt;Windows 7 For Dummies&lt;/em&gt;&amp;nbsp;will have you up and running on the newest version of Windows quickly and easily.&lt;/p&gt;', '3', 'IMG_62D3E8-C07202-710469-FC3FED-ACB5F6-D297B7.jpg', '', '', '', '', '30', '2011-07-22 11:13:37', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('26', '6', 'Growing at the Speed of Life', 'Growing-at-the-Speed-of-Life', '11.99', 'With more than two dozen cookbooks and hundreds of television shows, lectures, and personal appearances devoted to promoting healthful cooking, award-winning chef and former &quot;Galloping Gourmet&quot; Graham Kerr literally starts from the ground up in this engaging', '&lt;p&gt;With more than two dozen cookbooks and hundreds of television shows, lectures, and personal appearances devoted to promoting healthful cooking, award-winning chef and former &quot;Galloping Gourmet&quot; Graham Kerr literally starts from the ground up in this engaging, inspiring, and highly informative introduction to the joys of the kitchen garden-and the pleasures of the table that start with growing your own food. &lt;br/&gt;\r\n  &lt;br/&gt;\r\n  While Kerr taps into the current trend of sustainability, eating locally and organically, and eschewing fast food, he recognizes that today&#039;s home cooks are savvier and more discerning than their predecessors in the back-to-the-land movement. And in this day of rampant obesity and related diseases, he understands how critical taking these vital steps toward wellness can be.&lt;/p&gt;\r\n&lt;p&gt;&lt;em&gt;Growing at the Speed of Life&lt;/em&gt;&amp;nbsp;takes you through the first year in his kitchen garden, sharing the lessons learned and the wisdom received from his circle of local knowledge providers. From digging up his &quot;south lawn&quot; and putting together a greenhouse to planting his first seeds and harvesting and sharing his first crop with others in need, Kerr provides a whirlwind tour through his gardening adventures. Along the way, he profiles sixty common-and not-so-common but readily available-garden vegetables, fruits, and herbs with useful advice and recommendations for care and feeding.&lt;/p&gt;\r\n&lt;p&gt;Once the harvest is done, Kerr takes you into the kitchen, offering guidance on the best cooking methods to create appealing dishes in his inimitable and spirited style. He includes more than one hundred recipes that are as simple and elegant as they are healthful-and that will certainly entice you to increase the amount of plant foods in your diet.&lt;/p&gt;', '1', 'IMG_E77059-9259D6-CED570-E3E5BE-588B33-CFB95A.jpg', '', '', '', '', '50', '2011-07-22 11:16:04', '18', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('27', '6', 'Green Thoughts', 'Green-Thoughts', '11.99', 'A classic in the literature of the garden, Green Thoughts is a beautifully written and highly original collection of seventy-two essays, alphabetically arranged, on topics ranging from &quot;Annuals&quot; and &quot;Artichokes&quot; to &quot;Weeds&quot; and &quot;Wildflowers.&quot; An amateur gardener for over thirty years, Eleanor Per&eacute;nyi draws upon her wide-ranging', 'A classic in the literature of the garden,&amp;nbsp;&lt;em&gt;Green Thoughts&lt;/em&gt;&amp;nbsp;is a beautifully written and highly original collection of seventy-two essays, alphabetically arranged, on topics ranging from &ldquo;Annuals&rdquo; and &ldquo;Artichokes&rdquo; to &ldquo;Weeds&rdquo; and &ldquo;Wildflowers.&rdquo; An amateur gardener for over thirty years, Eleanor Per&eacute;nyi draws upon her wide-ranging knowledge of gardening lore to create a delightful, witty blend of how-to advice, informed opinion, historical insight, and philosophical musing. &lt;br/&gt;&lt;br/&gt;There are entries in praise of earthworms and in protest of rock gardens, a treatise on the sexual politics of tending plants, and a paean to the salubrious effect of gardening (see &ldquo;Longevity&rdquo;). Twenty years after its initial publication,&amp;nbsp;&lt;em&gt;Green Thoughts&lt;/em&gt;remains as much a joy to read as ever.\r\n&lt;p&gt;This Modern Library edition is published with a new Introduction by Allen Lacy, former gardening columnist for&amp;nbsp;&lt;em&gt;The Wall Street Journal&lt;/em&gt;&amp;nbsp;and&amp;nbsp;&lt;em&gt;The New York Times&lt;/em&gt;and the author of numerous gardening books.&lt;/p&gt;', '1', 'IMG_BB80AB-C42D9D-60B253-4515B3-465BEE-DA34D0.jpg', '', '', '', '', 'D50', '2011-07-22 11:17:52', '1', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('28', '6', 'Grow More in Less Space', 'Grow-More-in-Less-Space', '8.99', 'Sure, there are ten new features in this all-new, updated book. Sure, it&#039;s even simpler than it was before. Of course, you don&#039;t have to worry about fertilizer or poor soil ever again because you&#039;ll be growing above the ground.', '&lt;p&gt;Do you know what the best feature is in &quot;All New Square Foot Gardening&quot;?&lt;/p&gt;\r\n&lt;p&gt;Sure, there are ten new features in this all-new, updated book. Sure, it&#039;s even simpler than it was before. Of course, you don&#039;t have to worry about fertilizer or poor soil ever again because you&#039;ll be growing above the ground.&lt;/p&gt;\r\n&lt;p&gt;But, the best feature is that &quot;anyone,&quot; &quot;anywhere&quot; can enjoy a Square Foot garden. Children, adults with limited mobility, even complete novices can achieve spectacular results.&lt;/p&gt;\r\n&lt;p&gt;But, let&#039;s get back to the ten improvements. You&#039;re going to love them.&lt;/p&gt;\r\n&lt;p&gt;&amp;nbsp;&lt;/p&gt;\r\n&lt;p&gt;1) New Location - Move your garden closer to your house by eliminating single-row gardening. Square Foot Garden needs just &quot;twenty percent&quot; of the space of a traditional garden.&lt;/p&gt;\r\n&lt;p&gt;2) New Direction - Locate your garden &quot;on top&quot; of existing soil. Forget about pH soil tests, double-digging (who enjoys that?), or the never-ending soil improvements.&lt;/p&gt;\r\n&lt;p&gt;3) New Soil - The new &quot;Mel&#039;s Mix&quot; is the perfect growing mix. Why, we even give you the recipe. Best of all, you can even &quot;buy&quot; the different types of compost needed.&lt;/p&gt;\r\n&lt;p&gt;4) New Depth - You only need to prepare a SFG box to a depth of 6 inches! It&#039;s true--the majority of plants develop just fine when grown at this depth.&lt;/p&gt;\r\n&lt;p&gt;5) No Fertilizer - The all new SFG does not need any fertilizer-ever! If you start with the perfect soil mix, then you don&#039;t need to add fertilizer.&lt;/p&gt;\r\n&lt;p&gt;6)New Boxes - The new method uses bottomless boxes placed aboveground. We show you how to build your own (with step-by-step photos).&lt;/p&gt;\r\n&lt;p&gt;7) New Aisles - The ideal gardening aisle width is about three to four feet. That makes it even easier to kneel, work, and harvest.&lt;/p&gt;\r\n&lt;p&gt;8) New Grids - Prominent and permanent grids added to your SFG box help you visualize the planting squares and know how to space for maximum harvest.&lt;/p&gt;\r\n&lt;p&gt;9) New Seed Saving Idea - The old-fashioned way advocates planting many seeds and then thinning the extras (that means pulling them up). The new method means planting a pinch- literally two or three seeds--per planting hole.&lt;/p&gt;\r\n&lt;p&gt;10) Tabletop Gardens - The new boxes are so much smaller and lighter (only 6 inches of soil, remember?), you can add a plywood bottom to make them portable.&lt;/p&gt;\r\n&lt;p&gt;Of course, that&#039;s not all. We&#039;ve also included simple, easy-to-follow instructions using lots of photos and illustrations. You&#039;re going to love it!&lt;/p&gt;', '2', 'IMG_0D44F9-057547-875B01-01C8F0-E2F9FD-C9C323.jpg', '', '', '', '', 'D100', '2011-07-22 11:18:56', '18', '1', '0', '8', '1', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('29', '7', 'Turn Left at the Trojan Horse', 'Turn-Left-at-the-Trojan-Horse', '0.00', 'A modern-day Odysseus in Kerouac clothing, Brad Herzog plunges into a solo cross-country search for insight. With middle age bearing down on him, he takes stock: How has he measured up to his own youthful aspirations? In contemporary America, what is a life well lived? What is a heroic life?', '&lt;em&gt;&quot;Turn Left at the Trojan Horse&lt;/em&gt;&amp;nbsp;had me howling with laughter and nodding at the razor-sharp observation.&quot; --Tahir Shah, author of&amp;nbsp;&lt;em&gt;The Caliph&#039;s House&lt;/em&gt;\r\n&lt;p&gt;&lt;em&gt;&quot;Go away. Figure it out,&quot; she was saying. &quot;Don&#039;t come back until you do.&quot; She looked at the calendar. &quot;You have thirty-one days.&quot;&lt;/em&gt;&lt;/p&gt;\r\n&lt;p&gt;With these words, like Helen of Troy launching a thousand ships across the Aegean, Brad Herzog&#039;s wife launched a Winnebago Aspect onto the open road.&lt;/p&gt;\r\n&lt;p&gt;A modern-day Odysseus in Kerouac clothing, Brad Herzog plunges into a solo cross-country search for insight. With middle age bearing down on him, he takes stock: How has he measured up to his own youthful aspirations? In contemporary America, what is a life well lived? What is a heroic life?&lt;/p&gt;\r\n&lt;p&gt;From the foothills of Washington&#039;s Mount Olympus, through the forgotten corners of America, and finally to his college reunion in Ithaca, New York, Brad shares his personal odyssey. Stopping in classically named towns, he meets everyday heroes, including a teacher in a one-room schoolhouse in Troy, Oregon; a modern-day hobo in Iliad, Montana; and a bomb-squad soldier in Sparta, Wisconsin. These encounters and Brad&#039;s effortlessly infused musings make for an exciting, one-of-a-kind ride.&lt;/p&gt;\r\n&lt;p&gt;&quot;A truly epic journey.&quot;--A.J. Jacobs, author of&amp;nbsp;&lt;em&gt;The Year of Living Biblically&lt;/em&gt;&lt;/p&gt;\r\n&lt;p&gt;&quot;As we sit in Herzog&#039;s passenger seat, we cannot help but stare out the window and even see our own reflection in the glass.&quot;--Liz Robbins, author of&amp;nbsp;&lt;em&gt;A Race Like No Other&lt;/em&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Brad Herzog&lt;/strong&gt;&amp;nbsp;lives on California&#039;s Monterey Peninsula with his wife and their two sons. He has been described as a &quot;modern-day Steinbeck&quot; and a &quot;Picasso of the Winnebago,&quot; and Lonely Planet has ranked his travel memoirs among eight classics of the genre, along with books like Travels with Charley and On the Road. As an award-winning freelance writer, he has chronicled some of the nation&#039;s most unusual and intriguing subcultures, from nudists to North Pole explorers and from Pez collectors to pro mini golfers.&lt;/p&gt;', '3', 'IMG_0F5B4C-E6F9D6-3F985E-D63D2D-A01522-C0E6F5.jpg', '', '', '', '', 'D365', '2011-07-22 11:20:47', '9', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('30', '7', 'A Pedestrian in Paris', 'A-Pedestrian-in-Paris', '6.99', 'Thrust into the unlikely role of professional &quot;literary walking tour&quot; guide, an expat writer provides the most irresistibly witty and revealing tour of Paris in years.', '&lt;p&gt;Thrust into the unlikely role of professional &quot;literary walking tour&quot; guide, an expat writer provides the most irresistibly witty and revealing tour of Paris in years.&lt;/p&gt;\r\n&lt;p&gt;In this enchanting memoir, acclaimed author and long- time Paris resident John Baxter remembers his yearlong experience of giving &quot;literary walking tours&quot; through the city. Baxter sets off with unsuspecting tourists in tow on the trail of Paris&#039;s legendary artists and writers of the past.&lt;br/&gt;&lt;br/&gt; Along the way, he tells the history of Paris through a brilliant cast of characters: the favorite caf&eacute;s of Ernest Hemingway, F. Scott Fitzgerald, and James Joyce; Pablo Picasso&#039;s underground Montmartre haunts; the bustling boulevards of the late-nineteenth-century&lt;em&gt;fl&acirc;neurs&lt;/em&gt;; the secluded &quot;Little Luxembourg&quot; gardens beloved by Gertrude Stein; the alleys where revolutionaries plotted; and finally Baxter&#039;s own favorite walk near his home in Saint-Germain-des-Pr&eacute;s.&lt;/p&gt;\r\n&lt;p&gt;Paris, by custom and design, is a pedestrian&#039;s city&mdash;each block a revelation, every neighborhood a new feast for the senses, a place rich with history and romance at every turn.&amp;nbsp;&lt;em&gt;The Most Beautiful Walk in the World&lt;/em&gt;&amp;nbsp;is your guide, par excellence, to the true, off-the-beaten-path heart of the City of Lights.&lt;/p&gt;', '4', 'IMG_67D35E-A042D6-633513-D6FC0C-370787-BE778B.jpg', '', '', '', '', '365', '2011-07-22 11:26:47', '7', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('31', '7', 'Walking the Bible', 'Walking-the-Bible', '12.99', 'Its stories may be the best known in the world, but its locations have long been a mystery. Where did Noah&#039;s ark land? Where did Moses receive the Ten Commandments? Where are the lost cities of Sodom and Gomorrah? Now, inWalking the Bible: A Photographic Journey, New York Times bestselling author Bruce Feiler offers an unprecedented heart-stirring adventure through the landscape of some of history&#039;s most storied events.', '&lt;p&gt;&quot;The process of gathering these images reminded me of the Bible&#039;s effortless ability to reinvent itself for each generation and each new way of searching.&quot;&amp;nbsp;&lt;br/&gt;\r\n  &mdash;Bruce Feiler&lt;/p&gt;\r\n&lt;p&gt;Its stories may be the best known in the world, but its locations have long been a mystery. Where did Noah&#039;s ark land? Where did Moses receive the Ten Commandments? Where are the lost cities of Sodom and Gomorrah? Now, in&lt;em&gt;Walking the Bible: A Photographic Journey&lt;/em&gt;,&amp;nbsp;&lt;em&gt;New York Times&lt;/em&gt;&amp;nbsp;bestselling author Bruce Feiler offers an unprecedented heart-stirring adventure through the landscape of some of history&#039;s most storied events.&lt;/p&gt;\r\n&lt;p&gt;Featuring Bruce Feiler&#039;s own photography as well as his selections from professional collections,&amp;nbsp;&lt;em&gt;Walking the Bible: A Photographic Journey&lt;/em&gt;&amp;nbsp;brings together breathtaking vistas, intimate portraits, and fascinating panoramas, providing firsthand access to the inscrutable land where three of the world&#039;s great religions were born&mdash;and finally puts a face on the stories that have long inspired the human spirit.&lt;/p&gt;\r\n&lt;p&gt;Over several years, Feiler traveled nearly ten thousand miles through the deserts of the Middle East, which led first to his runaway national bestseller Walking the Bible. This new illustrated book follows his route, offering a thrilling photographic voyage through the actual places of some of the Bible&#039;s most memorable events&mdash;from the heights of Mount Ararat, where Noah&#039;s ark landed, to the desert outpost in Turkey, where Abraham first heard the words of God, to the summit where Moses overlooked the Promised Land.&lt;/p&gt;\r\n&lt;p&gt;&lt;em&gt;Walking the Bible: A Photographic Journey&lt;/em&gt;&amp;nbsp;chronicles a landscape that nurtured the relationship between humans and the divine, breathing new meaning into stories that have been a timeless source of inspiration.&lt;/p&gt;', '5', 'IMG_406FA7-1D5C38-B462B5-DBB8A8-1280CE-033638.jpg', '', '', '', '', '150', '2011-07-22 11:28:21', '15', '0', '0', '3', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('32', '7', 'For All the Tea in China', 'For-All-the-Tea-in-China', '9.99', 'In 1848, the British East India Company, having lost its monopoly on the tea trade, engaged Robert Fortune, a Scottish gardener, botanist, and plant hunter, to make a clandestine trip into the interior of China-territory forbidden to foreigners-to steal the closely guarded secrets of tea horticulture and manufacturing.', '&lt;p&gt;&lt;strong&gt;A dramatic historical narrative of the man who stole the secret of tea from China&lt;/strong&gt;&lt;/p&gt;\r\n&lt;p&gt;In 1848, the British East India Company, having lost its monopoly on the tea trade, engaged Robert Fortune, a Scottish gardener, botanist, and plant hunter, to make a clandestine trip into the interior of China-territory forbidden to foreigners-to steal the closely guarded secrets of tea horticulture and manufacturing.&amp;nbsp;&lt;em&gt;For All the Tea in China&lt;/em&gt;&amp;nbsp;is the remarkable account of Fortune&#039;s journeys into China-a thrilling narrative that combines history, geography, botany, natural science, and old-fashioned adventure.&lt;/p&gt;\r\n&lt;p&gt;Disguised in Mandarin robes, Fortune ventured deep into the country, confronting pirates, hostile climate, and his own untrustworthy men as he made his way to the epicenter of tea production, the remote Wu Yi Shan hills. One of the most daring acts of corporate espionage in history, Fortune&#039;s pursuit of China&#039;s ancient secret makes for a classic nineteenth-century adventure tale, one in which the fate of empires hinges on the feats of one extraordinary man.&lt;/p&gt;\r\n', '3', 'IMG_71EF42-B6C9E1-911929-371D01-F8C840-772FE7.jpg', '', '', '', '', '15', '2011-07-22 11:34:57', '7', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('33', '7', 'Fodor&#039;s Italy', 'Fodors-Italy', '14.99', 'No place better epitomizes the greatness of the Renaissance than Florence, where there&#039;s a masterpiece around every corner, from Michelangelo&#039;s David to Botticelli&#039;s Venus. The central regions of Tuscany and Umbria are characterized by midsize cities and small hilltop towns, each with its rich history and art treasures.', 'No place better epitomizes the greatness of the Renaissance than Florence, where there&rsquo;s a masterpiece around every corner, from Michelangelo&rsquo;s&amp;nbsp;&lt;em&gt;David&lt;/em&gt;&amp;nbsp;to Botticelli&rsquo;s&amp;nbsp;&lt;em&gt;Venus&lt;/em&gt;. The central regions of Tuscany and Umbria are characterized by midsize cities and small hilltop towns, each with its rich history and art treasures. Highlights include the walled city of Lucca; Pisa and the Leaning Tower, Siena, home of the Palio; and Assisi, the city of St. Francis. In between, the gorgeous countryside produces some of Italy&rsquo;s finest wine.&lt;br/&gt;\r\n&lt;br/&gt;\r\nThe region of Campania is a popular place both to unwind on the pint-size island of Capri or the resort towns of the Amalfi Coast and to explore the past at the archaeological ruins of Pompeii, Herculaneum, and Paestum. In the middle of everything is the vibrant, chaotic city of Naples. Farther south, in the off-the-beaten-path regions of Puglia, Basilicata, and Calabria, you&rsquo;ll find attractive beaches, mysterious ancient dwellings, and the charming town of Lecce. Across a narrow straight from Calabria is Sicily. Baroque church-hopping could be a sport on the cacophonous streets of Palermo and Siracusa, and amid the almond groves of Agrigento stands one of the world&rsquo;s best-preserved Greek ruins.&lt;br/&gt;\r\n&lt;br/&gt;\r\nItaly&rsquo;s capital is one of the great cities of Europe. It&rsquo;s a large, busy metropolis that lives in the here and now, yet there&rsquo;s no other place on earth where you&rsquo;ll encounter such powerful evocations of a long and spectacular past, from the Colosseum to the dome of St. Peter&rsquo;s. With more masterpieces per square foot than any other city in the world, Rome presents a particular challenge for visitors: just as they begin to feel smitten by the city, they realize they don&rsquo;t have time to see more than a fraction of its treasures. Explore all the glories of Rome that you can, from Ancient Rome and the Vatican to Piazza Navona and Trastevere.', '4', 'IMG_25AB7D-E390F7-5FB26C-1B0FD5-976D59-4DCAE9.jpg', '', '', '', '', 'D15', '2011-07-22 11:36:25', '6', '0', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('34', '7', 'Istanbul: Memories and the City', 'Istanbul-Memories-and-the-City', '10.99', 'Blending reminiscence with history; family photographs with portraits of poets and pashas; art criticism, metaphysical musing, and, now and again, a fanciful tale, Orhan Pamuk invents an ingenious form to evoke his lifelong home, the city that forged his imagination.', 'A portrait, by turns intimate and panoramic, of one of the world&rsquo;s great cities, by its foremost man of letters, author of the acclaimed novels&amp;nbsp;&lt;em&gt;Snow&lt;/em&gt;&amp;nbsp;and&amp;nbsp;&lt;em&gt;My Name Is Red&lt;/em&gt;.\r\n&lt;p&gt;Blending reminiscence with history; family photographs with portraits of poets and pashas; art criticism, metaphysical musing, and, now and again, a fanciful tale, Orhan Pamuk invents an ingenious form to evoke his lifelong home, the city that forged his imagination. &lt;br/&gt;\r\n  &lt;br/&gt;\r\n  He begins with his childhood among the eccentric extended Pamuk family in the dusty, carpeted, and hermetically sealed apartment building they shared. In this place came his first intimations of the melancholy awareness that binds all residents of his city together: that of living in the seat of ruined imperial glories, in a country trying to become &ldquo;modern&rdquo; at the dizzying crossroads of East and West. This elegiac communal spirit overhangs Pamuk&rsquo;s reflections as he introduces the writers and painters (among the latter, most particularly the German Antoine-Ignace Melling) through whose eyes he came to see Istanbul. &lt;br/&gt;\r\n  &lt;br/&gt;\r\n  Against a background of shattered monuments, neglected villas, ghostly backstreets, and, above all, the fabled waters of the Bosphorus, he presents the interplay of his budding sense of place with that of his predecessors. And he charts the evolution of a rich, sometimes macabre, imaginative life, which furnished a daydreaming boy refuge from family discord and inner turmoil, and which would continue to serve the famous writer he was to become. It was, and remains, a life fed by the changing microcosm of the apartment building and, even more, the beckoning kaleidoscope beyond its walls.&lt;/p&gt;\r\n&lt;p&gt;As much a portrait of the artist as a young man as it is an oneiric Joycean map of the city,&amp;nbsp;&lt;em&gt;Istanbul&lt;/em&gt;&amp;nbsp;is a masterful evocation of its subject through the idiosyncrasies of direct experience as much as the power of myth--the dazzling book Pamuk was born to write.&lt;/p&gt;', '4', 'IMG_ACFD51-E3DA7B-271ADE-482DC9-AC3511-D24D54.jpg', '', '', '', '', 'D40', '2011-07-22 11:39:22', '6', '2', '0', '5', '1', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('35', '7', 'Getting Stoned with Savages', 'Getting-Stoned-with-Savages', '0.00', 'With The Sex Lives of Cannibals, Maarten Troost established himself as one of the most engaging and original travel writers around. Getting Stoned with Savagesagain reveals his wry wit and infectious joy of discovery in a side-splittingly funny account of life in the farthest reaches of the world.', 'With&amp;nbsp;&lt;em&gt;The Sex Lives of Cannibals&lt;/em&gt;, Maarten Troost established himself as one of the most engaging and original travel writers around.&amp;nbsp;&lt;em&gt;Getting Stoned with Savages&lt;/em&gt;again reveals his wry wit and infectious joy of discovery in a side-splittingly funny account of life in the farthest reaches of the world. After two grueling years on the island of Tarawa, battling feral dogs, machete-wielding neighbors, and a lack of beer on a daily basis, Maarten Troost was in no hurry to return to the South Pacific. &lt;br/&gt;\r\n&lt;br/&gt;\r\nBut as time went on, he realized he felt remarkably out of place among the trappings of twenty-first-century America. When he found himself holding down a job&mdash;one that might possibly lead to a career&mdash;he knew it was time for him and his wife, Sylvia, to repack their bags and set off for parts unknown.&lt;br/&gt;\r\n&lt;em&gt;&lt;br/&gt;\r\nGetting Stoned with Savages&lt;/em&gt;&amp;nbsp;tells the hilarious story of Troost&rsquo;s time on Vanuatu&mdash;a rugged cluster of islands where the natives gorge themselves on kava and are still known to &ldquo;eat the man.&rdquo; Falling into one amusing misadventure after another, Troost struggles against typhoons, earthquakes, and giant centipedes and soon finds himself swept up in the laid-back, clothing-optional lifestyle of the islanders. &lt;br/&gt;\r\n&lt;br/&gt;\r\nWhen Sylvia gets pregnant, they decamp for slightly-more-civilized Fiji, a fallen paradise where the local chiefs can be found watching rugby in the house next door. And as they contend with new parenthood in a country rife with prostitutes and government coups, their son begins to take quite naturally to island living&mdash;in complete contrast to his dad.', '5', 'IMG_FE7611-90078A-C5E708-7BAE86-D4E0C8-C98A8E.jpg', '', '', '', '', '40', '2011-07-22 11:42:18', '14', '0', '0', '3', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('36', '7', 'A Family&#039;s Adventure at Sea', 'A-Familys-Adventure-at-Sea', '11.99', 'John and Jean had hoped to use the trip as a teaching opportunity, with the Emerald Jane as a floating classroom in which to instruct their children in important lessons&ndash;not only about the natural world but about the beauty of human life when stripped down to its essence, far from the trappings of civilization.', '&lt;p&gt;An exhilarating true-life adventure of one family&rsquo;s extraordinary sea voyage of self-discovery and survival, tragedy and triumph&lt;/p&gt;\r\n&lt;p&gt;Successful businessman John Silverwood and his wife, Jean, both experienced sailors, decided the time was right to give their four children a taste of thrilling life on the high seas. And indeed their journey aboard the fifty-five-foot catamaran Emerald Jane would have many extraordinary and profound moments, whether it was the peaceful late-night watches John enjoyed under the stunning celestial sky or the elation shared by the whole family at the sight of blissful pods of dolphin and migrating tortoises. John and Jean had hoped to use the trip as a teaching opportunity, with theEmerald Jane as a floating classroom in which to instruct their children in important lessons&ndash;not only about the natural world but about the beauty of human life when stripped down to its essence, far from the trappings of civilization.&lt;/p&gt;\r\n&lt;p&gt;Yet rather than flourishing amid the new freedoms and responsibilities thrust upon them, the children were sometimes confused, frightened, resentful. The two oldest, fourteen-year-old Ben and twelve-year-old Amelia, missed their friends and the comfortable life left behind in San Diego, while the two youngest, Jack, seven, and Camille, three, picked up on the stressful currents running above and below the surface&ndash;for throughout the journey, the Silverwood family found its bonds tested as never before.&lt;/p&gt;\r\n&lt;p&gt;John and Jean, whose marriage had weathered its share of storms, would wonder again if they had taken on too much as the physical, emotional, and financial strains of caring for the expensive catamaran and their children brought old resentments to the surface.&lt;/p&gt;\r\n&lt;p&gt;John&rsquo;s dream trip that began on Long Island Sound ended almost two years later as a nightmare in treacherous waters off a remote atoll in French Polynesia, where, in an explosion of awesome violence, the terrifying brunt of the ocean&rsquo;s anger fell upon the Emerald Jane.&lt;/p&gt;\r\n&lt;p&gt;Gradually, in the crucible of the sea, a stronger, more closely knit unit was forged. The Silverwoods became a crew. Then they became a family again. But just as it seemed to them that they had mastered every challenge, their world was shattered in a split-second of unimaginable horror. Now their real challenge began, forcing them to fight for their very lives.&lt;/p&gt;\r\n', '5', 'IMG_886B43-7DF7CC-61B22E-C6CDDE-832E46-A6CD1D.jpg', '', '', '', '', '60', '2011-07-22 11:43:36', '27', '1', '0', '4', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('37', '7', 'Fodor&#039;s Switzerland', 'Fodors-Switzerland', '11.99', 'Get inspired and plan your next trip with Fodor&#039;s ebook travel guide to Switzerland (including Z&uuml;rich, Eastern Switzerland and Liechtenstein, Graub&uuml;nden, Ticino, Luzern and Central Switzerland, Basel, Fribourg and Neuch&acirc;tel, Bern, Berner Oberland, Valais, Vaud, and Geneva).', 'Get inspired and plan your next trip with Fodor&rsquo;s ebook travel guide to Switzerland (including Z&uuml;rich, Eastern Switzerland and Liechtenstein, Graub&uuml;nden, Ticino&lt;strong&gt;,&amp;nbsp;&lt;/strong&gt;Luzern and Central Switzerland, Basel, Fribourg and Neuch&acirc;tel, Bern, Berner Oberland, Valais, Vaud, and Geneva).&lt;strong&gt;&lt;/strong&gt;&lt;br/&gt;\r\n&lt;strong&gt;&lt;br/&gt;\r\nWhat&rsquo;s Covered? Get to Know Switzerland&lt;/strong&gt;: Z&uuml;rich is surprisingly small, but its wealth of cultural riches&mdash;like luxurious Alstadt (Old Town), Grossm&uuml;nster cathedral, and the modern art at the B&uuml;hrle Museum&mdash;make up for its size. East of Z&uuml;rich, discover the old Rhine city of Schaffhausen and its medieval frescoes, the busy textile center of St. Gallen, and princely Liechtenstein.&lt;br/&gt;\r\n&lt;br/&gt;\r\nIn Graub&uuml;nden, take the gorgeous train ride to Arosa, visit Heidi country in Maienfeld, or ski and be seen in glitzy St. Moritz. Ticino&rsquo;s lakes, like the beauteous Lugano, serene Locarno, and elegant Ascona, are perhaps its greatest attraction. Central Switzerland is the most-visited region in the country, with Vierwaldst&auml;ttersee lake, R&uuml;tli Meadow, fabled Wilhelm Tell chapel, and the medieval town of Luzern.&lt;br/&gt;\r\n&lt;br/&gt;\r\nBasel is home to great modern art, at Museum Tinguely and Fondation Beyeler. The largely undiscovered cantons of Fribourg and Neuch&acirc;tel are a favorite western Switzerland getaway, with treasures like the picturesque castle at Gruy&egrave;res, lakeside Neuch&acirc;tel, and the medieval center of Fribourg. Bern, Switzerland&rsquo;s federal capital, offers famed sandstone arcades, painted fountains, the Zytglogge performing mechanical clock, the Gothic M&uuml;nster, and the art-filled Zentrum Paul Klee.&lt;br/&gt;\r\n&lt;br/&gt;\r\nBerner Oberland, a summit of summits, includes the peaks of Eiger, M&ouml;nch, and Jungfrau as well as glam Gstaad. Valais is home to the country&#039;s most photographed icon, the Matterhorn, in Zermatt. Don&rsquo;t miss the resort luxury of Saas-Fee, Verbier, and Crans-Montana. Vaud is centered around Lac L&eacute;man (Lake Geneva) and harbors alpine villages, glamorous lake resorts, and verdant vineyards. Be sure to visit the Old Town and hyperactive waterfront of Lausanne, harbor-front Vevey, Riviera-like Montreux, and Switzerland&rsquo;s most fabled castle, Ch&acirc;teau de Chillon. &lt;br/&gt;', '9', 'IMG_E125B0-A050C3-EF9680-40B9C8-FAF328-B419B2.jpg', '', '', 'AUD_424C57-435E7E-5B3CB7-561936-045879-F2B2BD.mp3', '', 'D60', '2011-07-22 11:45:50', '43', '0', '1', '5', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('38', '7', 'India: A Million Mutinies Now', 'India-A-Million-Mutinies-Now', '2.99', 'Arising out of Naipaul&#039;s lifelong obsession and passion for a country that is at once his and totally alien, India: A Million Mutinies Now relates the stories of many of the people he met traveling there more than fifty years ago.', '&lt;p&gt;Nobel laureate V. S. Naipaul&rsquo;s impassioned and prescient travelogue of his journeys through his ancestral homeland, with a new preface by the author.&lt;br/&gt;\r\n  &lt;br/&gt;\r\n  Arising out of Naipaul&rsquo;s lifelong obsession and passion for a country that is at once his and totally alien,&amp;nbsp;&lt;em&gt;India: A Million Mutinies Now&amp;nbsp;&lt;/em&gt;relates the stories of many of the people he met traveling there more than fifty years ago. He explores how they have been steered by the innumerable frictions present in Indian society&mdash;the contradictions and compromises of religious faith, the whim and chaos of random political forces. &lt;br/&gt;\r\n  &lt;br/&gt;\r\n  This book represents Naipaul&rsquo;s last word on his homeland, complementing his two other India travelogues,&amp;nbsp;&lt;em&gt;An Area of Darkness&lt;/em&gt;and&amp;nbsp;&lt;em&gt;India: A Wounded Civilization&lt;/em&gt;.&lt;/p&gt;\r\n&lt;h4&gt;Annotation&lt;/h4&gt;\r\nNaipaul, of Indian heritage, was born and raised in Trinidad, but he recognized that it was his ancestral culture that governed who he was and how he thought. In this passionate portrait of a culture, a society, and a country, he returns to India, a nation in turmoil.', '10', 'IMG_D816E9-31B45A-B4BCA4-A08089-9F264D-A1DAA6.jpg', '', '', '', '', 'D60', '2011-07-22 11:48:02', '27', '2', '0', '0', '0', '', '', '1');
INSERT INTO `products` (`id`, `cid`, `title`, `slug`, `price`, `description`, `body`, `file_id`, `thumb`, `preview`, `affiliate`, `audio`, `youtube`, `expiry`, `created`, `hits`, `vote_up`, `vote_down`, `rating`, `ratingc`, `metakeys`, `metadesc`, `active`) VALUES ('39', '7', 'Life on a Very Small Island', 'life-on-a-very-small-island', '6.99', 'After seventeen years at sea, Linda Greenlaw figured it was time to take a break from her career as a swordboat captain. She felt she needed to return to Isle au Haut - a tiny island seven miles from the Maine coast with a population of 70 year-round residents, 30 of whom were her relatives.', '&lt;p&gt;After seventeen years at sea, Linda Greenlaw figured it was time to take a break from her career as a swordboat captain. She felt she needed to return to Isle au Haut - a tiny island seven miles from the Maine coast with a population of 70 year-round residents, 30 of whom were her relatives. She would pursue a simpler life; move back in with her parents and get to know them again; become a professional lobsterman; and find a guy, build a house, have kids, and settle down.&lt;/p&gt;\r\n&lt;p&gt;But all doesn&#039;t go as planned. The lobsters resolutely refuse to crawl out from under their rocks and into the traps she and her stern man (AKA, her father) have painstakingly set. Her fellow Islanders, an extraordinary collection of characters, draw her into their bizarre Island intrigues. &lt;br&gt;&lt;br&gt;Guys prove even more elusive than lobsters. And as mainlanders increasingly fish waters that are supposed to be reserved for Islanders, she realizes the that the Island might be heading for a &quot;gear war,&quot; a series of attacks that had in the past escalated from sabotage of equipment to extreme violence.&lt;/p&gt;\r\n&lt;p&gt;Then, just when she thinks things couldn&#039;t get much worse, something happens that forces her to reevaluate everything she thought she knew about life, luck, and lobsters.&lt;/p&gt;', '11', 'IMG_E822DD-BAF049-275E36-EE6B10-71CF6E-FAB571.jpg', 'http://google.com', 'http://google.com', 'AUD_424C57-435E7E-5B3CB7-561936-045879-F2B2BD.mp3', 'XSGBVzeBUbk', '100', '2011-07-22 11:49:33', '15104', '16', '7', '45', '10', 'island,life,lobsters,islanders', 'After seventeen years at sea, Linda Greenlaw figured it was time to take a break from her career as&#8230;', '1');


-- --------------------------------------------------
# -- Table structure for table `recent`
-- --------------------------------------------------
DROP TABLE IF EXISTS `recent`;
CREATE TABLE `recent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `user_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `recent`
-- --------------------------------------------------

INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('1', '1', 'ff32e7b1db593a7daf249f50564802322be8ae86');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('2', '11', 'ff32e7b1db593a7daf249f50564802322be8ae86');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('3', '36', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('4', '34', '5388ddcce153dfb762d31fc67fdf18fd25aaf775');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('5', '38', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('6', '39', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('7', '32', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('8', '37', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('9', '28', '6e32d8cf5b5cf595babaf968ebeda069914c5a07');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('10', '38', '6e32d8cf5b5cf595babaf968ebeda069914c5a07');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('11', '39', '6e32d8cf5b5cf595babaf968ebeda069914c5a07');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('12', '4', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('13', '2', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('14', '25', 'b8f6cf92b4f877d4735a6345b5a74b8a2db9166e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('15', '1', '56821a48745ec2164a247ac1ba44427a7dc20515');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('16', '39', '61344b3c2ac23e860d9ed3ab1ab8e8b49830fa2d');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('17', '32', '2e684b7fdc95d8d766b77f4dac7fd512513a0ea8');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('18', '39', '2e684b7fdc95d8d766b77f4dac7fd512513a0ea8');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('19', '39', 'aae85a3fb693f86958d983acf8c213a87d781a6c');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('20', '38', 'a8273114aa5f8bafc03cda640df86c88890ad8a6');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('21', '38', 'f9d5062b1e3f4b5fdbbe437eeffa50806aa026d2');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('22', '39', 'f9d5062b1e3f4b5fdbbe437eeffa50806aa026d2');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('23', '39', '0af206d61a39f079ead90cf3de6088951deeaa54');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('24', '36', '0af206d61a39f079ead90cf3de6088951deeaa54');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('25', '39', 'e51447d4486166dd701eb50d839be9830c493637');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('26', '39', '8a348392576274f65b0f74f6f08c1f8a9b35ba50');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('27', '34', 'b2653f214e3c19ce5c232a41e16251d386a72d0d');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('28', '39', 'b2653f214e3c19ce5c232a41e16251d386a72d0d');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('29', '39', '10f8acdff0d35b1975ad43a86d36e8781ab1d635');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('30', '1', 'da775b9017791eb9bf1b25600d61cc99423f24a7');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('31', '2', 'da775b9017791eb9bf1b25600d61cc99423f24a7');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('32', '39', '6b1b785dcb427714f4cd44f9b8441c76356bb3d2');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('33', '2', '6b1b785dcb427714f4cd44f9b8441c76356bb3d2');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('34', '1', '6b1b785dcb427714f4cd44f9b8441c76356bb3d2');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('35', '39', '30584aaf396bde17da876d025324a7ab0094d54c');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('36', '4', '30584aaf396bde17da876d025324a7ab0094d54c');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('37', '4', '94c4e01eee527a0836045667d0399f51be567668');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('38', '39', '957cdb2ff7b2d14c341ab02ef6f5b9340f3ea02e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('39', '2', '957cdb2ff7b2d14c341ab02ef6f5b9340f3ea02e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('40', '39', 'faf49cee698413716dddd8628f992ba95e0a5bc8');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('41', '28', '5daed77dc2f46caf4523508f0e5455da943ff38e');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('42', '39', '6fe6809f45cdfa88440094cfee79d4b8be4e6a45');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('43', '39', '5738506b94a87c0e5d31c5e3dcbaf0af9dc179c4');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('44', '39', '3f0617c367ae9974170c7098e21ee78c5fdf87a3');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('45', '39', '1a025562ca77f9caf7aa6a0350b5e39a0fc0cd6a');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('46', '39', '72b09af3d3f67cb6576f8b3ccc5696cb3dfe6bd7');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('47', '39', 'b24c1f22db26ebde5a15ef95199e3c46ae2eb9b8');
INSERT INTO `recent` (`id`, `pid`, `user_id`) VALUES ('48', '2', 'b24c1f22db26ebde5a15ef95199e3c46ae2eb9b8');


-- --------------------------------------------------
# -- Table structure for table `settings`
-- --------------------------------------------------
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `site_name` varchar(100) NOT NULL,
  `company` varchar(100) NOT NULL,
  `site_url` varchar(150) NOT NULL,
  `site_dir` varchar(60) DEFAULT NULL,
  `site_email` varchar(50) NOT NULL,
  `seo` tinyint(1) NOT NULL DEFAULT '0',
  `perpage` tinyint(4) NOT NULL DEFAULT '10',
  `backup` varchar(25) NOT NULL,
  `thumb_w` varchar(3) NOT NULL,
  `thumb_h` varchar(3) NOT NULL,
  `img_w` varchar(5) NOT NULL,
  `img_h` varchar(5) NOT NULL,
  `show_home` tinyint(1) NOT NULL DEFAULT '1',
  `show_slider` tinyint(1) NOT NULL DEFAULT '1',
  `file_dir` varchar(200) DEFAULT NULL,
  `short_date` varchar(50) NOT NULL,
  `long_date` varchar(50) NOT NULL,
  `dtz` varchar(120) DEFAULT NULL,
  `featured` varchar(2) NOT NULL DEFAULT '10',
  `popular` varchar(2) NOT NULL DEFAULT '6',
  `free_allowed` tinyint(1) NOT NULL DEFAULT '0',
  `logo` varchar(100) DEFAULT NULL,
  `theme` varchar(30) DEFAULT NULL,
  `lang` varchar(10) DEFAULT NULL,
  `currency` varchar(8) DEFAULT NULL,
  `cur_symbol` varchar(6) DEFAULT NULL,
  `reg_verify` tinyint(1) NOT NULL DEFAULT '1',
  `auto_verify` tinyint(1) NOT NULL DEFAULT '1',
  `reg_allowed` tinyint(1) NOT NULL DEFAULT '1',
  `user_limit` int(6) NOT NULL DEFAULT '0',
  `notify_admin` tinyint(1) NOT NULL DEFAULT '0',
  `offline` tinyint(1) NOT NULL DEFAULT '0',
  `offline_msg` text,
  `offline_data` varchar(20) DEFAULT NULL,
  `metakeys` text,
  `metadesc` text,
  `analytics` text,
  `mailer` enum('PHP','SMTP') DEFAULT NULL,
  `smtp_host` varchar(150) DEFAULT NULL,
  `smtp_user` varchar(50) DEFAULT NULL,
  `smtp_pass` varchar(50) DEFAULT NULL,
  `smtp_port` smallint(3) DEFAULT NULL,
  `is_ssl` tinyint(1) NOT NULL DEFAULT '0',
  `version` varchar(10) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `settings`
-- --------------------------------------------------

INSERT INTO `settings` (`site_name`, `company`, `site_url`, `site_dir`, `site_email`, `seo`, `perpage`, `backup`, `thumb_w`, `thumb_h`, `img_w`, `img_h`, `show_home`, `show_slider`, `file_dir`, `short_date`, `long_date`, `dtz`, `featured`, `popular`, `free_allowed`, `logo`, `theme`, `lang`, `currency`, `cur_symbol`, `reg_verify`, `auto_verify`, `reg_allowed`, `user_limit`, `notify_admin`, `offline`, `offline_msg`, `offline_data`, `metakeys`, `metadesc`, `analytics`, `mailer`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `is_ssl`, `version`) VALUES ('Digital Downloads Pro', 'wojoscripts.com', 'http://agda-graph', 'ddp3', 'alex.kuzmanovic@gmail.com', '1', '10', '17-Dec-2013_21-23-44.sql', '270', '350', '0', '0', '0', '1', 'W:/public_html/ddp3/filedata/', '%m-%d-%Y', '%B %d, %Y %I:%M %p', 'America/Toronto', '12', '6', '0', 'logo.png', 'master', 'en', 'CAD', '$', '1', '1', '1', '0', '1', '0', '', '2013:10:31 12:26:00', 'metakeys, separated,by coma', 'Your website description goes here', '', 'PHP', 'mail.hostname.com', 'yourusername', 'yourpass', '127', '0', '3.00');


-- --------------------------------------------------
# -- Table structure for table `slider`
-- --------------------------------------------------
DROP TABLE IF EXISTS `slider`;
CREATE TABLE `slider` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `thumb` varchar(60) DEFAULT NULL,
  `caption` varchar(100) DEFAULT NULL,
  `body` text,
  `url` varchar(150) DEFAULT NULL,
  `page_id` smallint(6) NOT NULL DEFAULT '0',
  `urltype` enum('int','ext','nourl') DEFAULT 'nourl',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sorting` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `slider`
-- --------------------------------------------------

INSERT INTO `slider` (`id`, `thumb`, `caption`, `body`, `url`, `page_id`, `urltype`, `created`, `sorting`) VALUES ('1', 'IMG_BDEEF2-BD6A38-2DF726-0B6A9A-90419C-4A212A.jpg', 'Sekve sanskrito malantaŭa fin bo', '', '', '0', 'nourl', '2013-10-22 12:36:11', '2');
INSERT INTO `slider` (`id`, `thumb`, `caption`, `body`, `url`, `page_id`, `urltype`, `created`, `sorting`) VALUES ('2', 'IMG_891380-EB6495-86E6B7-5C88E4-CD70C8-5ECECC.jpg', 'Mem pero numero disskribado', '', '#', '0', 'nourl', '2013-10-22 12:36:13', '1');
INSERT INTO `slider` (`id`, `thumb`, `caption`, `body`, `url`, `page_id`, `urltype`, `created`, `sorting`) VALUES ('3', 'IMG_739E3C-700690-7D9ED4-5C300E-7145E3-D2609B.jpg', 'Tiama latina transitiva ts kuo', '', '', '0', 'nourl', '2013-10-22 12:36:14', '3');
INSERT INTO `slider` (`id`, `thumb`, `caption`, `body`, `url`, `page_id`, `urltype`, `created`, `sorting`) VALUES ('4', 'IMG_3A47CE-0FB236-F24D08-DAA1A0-04D903-E3D869.jpg', 'Vira memmortigo du nur', '', '', '0', 'nourl', '2013-10-22 12:36:16', '4');


-- --------------------------------------------------
# -- Table structure for table `slider_config`
-- --------------------------------------------------
DROP TABLE IF EXISTS `slider_config`;
CREATE TABLE `slider_config` (
  `showArrows` tinyint(1) NOT NULL DEFAULT '1',
  `showCaptions` tinyint(1) NOT NULL DEFAULT '1',
  `showDots` tinyint(1) NOT NULL DEFAULT '1',
  `showFilmstrip` tinyint(1) NOT NULL DEFAULT '0',
  `showPause` tinyint(1) NOT NULL DEFAULT '1',
  `showTimer` tinyint(1) NOT NULL DEFAULT '1',
  `simultaneousCaptions` tinyint(1) NOT NULL DEFAULT '0',
  `slideImageScaleMode` varchar(20) NOT NULL DEFAULT 'fill',
  `slideReverse` tinyint(1) NOT NULL DEFAULT '0',
  `slideShuffle` tinyint(1) NOT NULL DEFAULT '0',
  `slideTransition` varchar(20) NOT NULL DEFAULT 'slide',
  `slideTransitionDelay` smallint(6) NOT NULL DEFAULT '5000',
  `slideTransitionDirection` varchar(10) NOT NULL DEFAULT 'left',
  `slideTransitionEasing` varchar(20) NOT NULL DEFAULT 'swing',
  `slideTransitionSpeed` smallint(6) NOT NULL DEFAULT '1000',
  `sliderAutoPlay` tinyint(1) NOT NULL DEFAULT '1',
  `sliderHeight` smallint(6) NOT NULL DEFAULT '500',
  `sliderHeightAdaptable` tinyint(1) NOT NULL DEFAULT '1',
  `waitForLoad` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `slider_config`
-- --------------------------------------------------

INSERT INTO `slider_config` (`showArrows`, `showCaptions`, `showDots`, `showFilmstrip`, `showPause`, `showTimer`, `simultaneousCaptions`, `slideImageScaleMode`, `slideReverse`, `slideShuffle`, `slideTransition`, `slideTransitionDelay`, `slideTransitionDirection`, `slideTransitionEasing`, `slideTransitionSpeed`, `sliderAutoPlay`, `sliderHeight`, `sliderHeightAdaptable`, `waitForLoad`) VALUES ('1', '1', '1', '0', '1', '1', '0', 'fill', '0', '0', 'slide', '5000', 'left', 'swing', '1000', '1', '500', '1', '1');


-- --------------------------------------------------
# -- Table structure for table `stats`
-- --------------------------------------------------
DROP TABLE IF EXISTS `stats`;
CREATE TABLE `stats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` date NOT NULL DEFAULT '0000-00-00',
  `pid` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `uhits` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=162 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `stats`
-- --------------------------------------------------

INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('1', '2010-04-15', '1', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('2', '2010-04-16', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('3', '2010-05-10', '1', '6', '7');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('4', '2009-02-05', '1', '5', '7');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('5', '2009-04-14', '1', '9', '8');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('6', '2010-08-23', '4', '73', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('7', '2010-08-23', '4', '0', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('8', '2010-08-23', '3', '47', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('9', '2010-08-23', '5', '85', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('10', '2010-08-24', '3', '7', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('11', '2010-08-24', '5', '2', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('12', '2012-02-24', '13', '25', '7');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('13', '2010-08-25', '3', '4', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('14', '2010-08-25', '5', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('15', '2010-08-25', '4', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('16', '2010-08-26', '8', '10', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('17', '2010-08-26', '5', '2', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('18', '2010-08-26', '4', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('19', '2010-08-27', '4', '2', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('20', '2010-08-27', '7', '13', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('21', '2012-08-27', '5', '5', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('22', '2012-08-27', '13', '9', '14');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('23', '2012-08-28', '7', '2258', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('24', '2012-08-28', '13', '49', '28');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('25', '2010-08-28', '4', '44', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('26', '2010-08-28', '3', '12', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('27', '2010-08-28', '2', '9', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('28', '2010-08-28', '0', '336', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('29', '2010-08-28', '13', '84', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('30', '2010-08-28', '139', '6', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('31', '2010-08-28', '13', '6', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('32', '2010-08-28', '13', '13', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('33', '2010-08-30', '13', '4', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('34', '2010-08-30', '13', '5', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('35', '2010-09-01', '13', '11', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('36', '2010-09-03', '13', '2', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('37', '2012-12-02', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('38', '2010-12-02', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('39', '2012-06-07', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('40', '2012-07-22', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('41', '2012-09-22', '13', '1', '12');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('42', '2012-09-22', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('43', '2012-10-15', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('44', '2012-10-15', '13', '1', '0');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('48', '2012-11-29', '1', '84', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('49', '2012-11-29', '39', '31', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('50', '2012-11-29', '37', '48', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('51', '2012-11-29', '38', '3', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('52', '2012-11-29', '35', '3', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('53', '2012-12-01', '1', '193', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('54', '2012-12-01', '39', '33', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('55', '2012-12-02', '1', '314', '7');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('56', '2012-12-02', '39', '10', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('57', '2012-12-02', '37', '5', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('58', '2012-12-03', '39', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('59', '2012-12-03', '1', '66', '3');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('60', '2012-12-04', '1', '224', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('61', '2012-12-04', '13', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('62', '2012-12-04', '5', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('63', '2012-12-04', '22', '7', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('64', '2012-12-06', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('65', '2012-12-09', '1', '130', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('66', '2012-12-09', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('67', '2012-12-11', '1', '35', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('68', '2012-12-11', '22', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('69', '2012-12-11', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('70', '2012-12-11', '38', '8', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('71', '2012-12-12', '38', '9', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('72', '2012-12-12', '37', '24', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('73', '2012-12-12', '39', '4', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('74', '2012-12-12', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('75', '2012-12-13', '1', '15', '3');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('76', '2012-12-13', '35', '2', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('77', '2012-12-13', '31', '10', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('78', '2012-12-13', '39', '22', '3');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('79', '2012-12-14', '1', '107', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('80', '2012-12-14', '39', '3', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('81', '2012-12-14', '21', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('82', '2012-12-14', '25', '6', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('83', '2012-12-15', '1', '8', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('84', '2012-12-20', '39', '21', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('85', '2012-12-20', '22', '7', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('86', '2012-12-20', '5', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('87', '2012-12-21', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('88', '2012-12-25', '37', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('89', '2012-12-25', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('90', '2012-12-27', '1', '5', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('91', '2012-12-28', '1', '25', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('92', '2012-12-29', '39', '6', '3');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('93', '2012-12-31', '1', '9', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('94', '2013-01-01', '1', '13', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('95', '2013-01-01', '36', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('96', '2013-01-01', '35', '10', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('97', '2013-01-01', '33', '10', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('98', '2013-01-02', '37', '5', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('99', '2013-01-02', '39', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('100', '2013-01-05', '37', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('101', '2013-01-07', '1', '22', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('102', '2013-01-07', '25', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('103', '2013-01-07', '39', '6', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('104', '2013-04-16', '1', '22', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('105', '2013-05-06', '36', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('106', '2013-05-22', '24', '18', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('107', '2013-05-22', '37', '20', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('108', '2013-06-23', '37', '6', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('109', '2013-06-23', '1', '10', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('110', '2013-06-23', '22', '16', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('111', '2013-06-23', '4', '3', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('112', '2013-07-24', '1', '4', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('113', '2013-10-13', '1', '15', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('114', '2013-10-14', '1', '20', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('115', '2013-10-14', '11', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('116', '2013-10-15', '36', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('117', '2013-10-15', '34', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('118', '2013-10-16', '38', '9', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('119', '2013-10-16', '39', '11', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('120', '2013-10-17', '32', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('121', '2013-10-17', '39', '45', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('122', '2013-10-18', '37', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('123', '2013-10-18', '39', '410', '10');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('124', '2013-10-18', '38', '145', '4');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('125', '2013-10-18', '28', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('126', '2013-10-18', '4', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('127', '2013-10-18', '32', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('128', '2013-10-18', '2', '9', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('129', '2013-10-18', '36', '15', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('130', '2013-10-18', '25', '10', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('131', '2013-10-19', '38', '8', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('132', '2013-10-19', '2', '6', '3');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('133', '2013-10-19', '1', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('134', '2013-10-19', '39', '7', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('135', '2013-10-21', '39', '12', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('136', '2013-10-21', '32', '5', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('137', '2013-10-22', '39', '6', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('138', '2013-10-22', '38', '10', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('139', '2013-10-23', '39', '4', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('140', '2013-10-23', '36', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('141', '2013-10-24', '39', '20', '3');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('142', '2013-10-24', '34', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('143', '2013-10-25', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('144', '2013-11-02', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('145', '2013-11-10', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('146', '2013-11-10', '2', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('147', '2013-11-14', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('148', '2013-11-14', '2', '11', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('149', '2013-11-14', '1', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('150', '2013-11-17', '39', '7', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('151', '2013-11-17', '4', '32', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('152', '2013-11-20', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('153', '2013-11-21', '2', '7', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('154', '2014-02-11', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('155', '2014-02-23', '28', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('156', '2014-02-24', '39', '6', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('157', '2014-04-08', '39', '1', '1');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('158', '2014-05-11', '39', '9', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('159', '2014-05-15', '39', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('160', '2014-09-11', '39', '3', '2');
INSERT INTO `stats` (`id`, `day`, `pid`, `hits`, `uhits`) VALUES ('161', '2014-09-11', '2', '1', '1');


-- --------------------------------------------------
# -- Table structure for table `tags`
-- --------------------------------------------------
DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `pid` int(11) NOT NULL DEFAULT '0',
  `tag` varchar(255) NOT NULL,
  KEY `idx_content_id` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `tags`
-- --------------------------------------------------

INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'war');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'lobster');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'life');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'island');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'greenlaw');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'gear');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('39', 'chronicles');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('40', 'eryery');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('40', 'ryery');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('40', 'sdgg');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('40', 'sgsdgsdg');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('41', 'bla gaga');
INSERT INTO `tags` (`pid`, `tag`) VALUES ('41', 'bla');


-- --------------------------------------------------
# -- Table structure for table `transactions`
-- --------------------------------------------------
DROP TABLE IF EXISTS `transactions`;
CREATE TABLE `transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `txn_id` varchar(50) NOT NULL,
  `pid` int(11) DEFAULT NULL,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `downloads` int(11) unsigned DEFAULT '0',
  `file_date` int(11) unsigned DEFAULT NULL,
  `ip` text,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payer_email` varchar(75) DEFAULT NULL,
  `payer_status` varchar(50) DEFAULT NULL,
  `item_qty` int(11) NOT NULL DEFAULT '1',
  `price` decimal(9,2) NOT NULL DEFAULT '0.00',
  `mc_fee` decimal(9,2) NOT NULL DEFAULT '0.00',
  `currency` char(3) DEFAULT NULL,
  `pp` varchar(40) DEFAULT NULL,
  `memo` text,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `transactions`
-- --------------------------------------------------

INSERT INTO `transactions` (`id`, `txn_id`, `pid`, `uid`, `downloads`, `file_date`, `ip`, `created`, `payer_email`, `payer_status`, `item_qty`, `price`, `mc_fee`, `currency`, `pp`, `memo`, `status`, `active`) VALUES ('1', 'MNHJ850JHT1', '1', '1', '14', '1225200679', '', '2014-06-29 08:27:14', 'webmaster@myemail.com', 'verified', '1', '19.99', '0.00', 'USD', 'PayPal', 'This is a note section', '1', '1');
INSERT INTO `transactions` (`id`, `txn_id`, `pid`, `uid`, `downloads`, `file_date`, `ip`, `created`, `payer_email`, `payer_status`, `item_qty`, `price`, `mc_fee`, `currency`, `pp`, `memo`, `status`, `active`) VALUES ('2', '34MNH76TYER', '2', '1', '18', '1225200679', '', '2014-07-27 08:27:14', 'webmaster@myemail.com', 'verified', '1', '29.99', '0.00', 'USD', 'Skrill', '', '1', '1');
INSERT INTO `transactions` (`id`, `txn_id`, `pid`, `uid`, `downloads`, `file_date`, `ip`, `created`, `payer_email`, `payer_status`, `item_qty`, `price`, `mc_fee`, `currency`, `pp`, `memo`, `status`, `active`) VALUES ('3', 'MAN_RNKL097', '32', '1', '7', '1267485224', '', '2014-07-01 18:13:44', 'webmaster@myemail.com', 'verified', '1', '1.00', '0.00', 'USD', 'PayPal', 'this is a note...', '1', '1');
INSERT INTO `transactions` (`id`, `txn_id`, `pid`, `uid`, `downloads`, `file_date`, `ip`, `created`, `payer_email`, `payer_status`, `item_qty`, `price`, `mc_fee`, `currency`, `pp`, `memo`, `status`, `active`) VALUES ('4', 'TUPO987GHNB', '4', '1', '5', '1268412378', '', '2014-07-12 11:46:18', 'webmaster@myemail.com', 'verified', '1', '1.99', '0.00', 'USD', 'Payza', 'This is client note', '1', '1');
INSERT INTO `transactions` (`id`, `txn_id`, `pid`, `uid`, `downloads`, `file_date`, `ip`, `created`, `payer_email`, `payer_status`, `item_qty`, `price`, `mc_fee`, `currency`, `pp`, `memo`, `status`, `active`) VALUES ('5', 'WURT64H5TGH', '1', '1', '0', '1268892404', '', '2014-07-14 12:10:15', 'webmaster@myemail.com', 'verified', '1', '8.99', '0.00', 'USD', 'Skrill', '', '1', '1');


-- --------------------------------------------------
# -- Table structure for table `users`
-- --------------------------------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(80) NOT NULL,
  `fname` varchar(100) NOT NULL,
  `lname` varchar(100) NOT NULL,
  `email` varchar(150) NOT NULL,
  `newsletter` tinyint(1) NOT NULL DEFAULT '0',
  `cookie_id` varchar(50) NOT NULL DEFAULT '0',
  `token` varchar(50) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT '0000-00-00 00:00:00',
  `avatar` varchar(50) DEFAULT NULL,
  `notes` text,
  `info` text,
  `lastlogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastip` varchar(16) DEFAULT NULL,
  `userlevel` tinyint(1) NOT NULL DEFAULT '1',
  `active` enum('y','n','t','b') NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- --------------------------------------------------
# Dumping data for table `users`
-- --------------------------------------------------

INSERT INTO `users` (`id`, `username`, `password`, `fname`, `lname`, `email`, `newsletter`, `cookie_id`, `token`, `created`, `avatar`, `notes`, `info`, `lastlogin`, `lastip`, `userlevel`, `active`) VALUES ('1', 'admin', '42b7b504b2753b71f41780d5e86f1139a2ab5647', 'Web', 'Master', 'gewa@rogers.com', '0', '29ffd0de6a157a55d10ca36b18cff47c79510cd9', '0', '2011-03-27 19:10:44', 'team7.jpg', '', '', '2014-09-16 01:03:17', '127.0.0.1', '9', 'y');
INSERT INTO `users` (`id`, `username`, `password`, `fname`, `lname`, `email`, `newsletter`, `cookie_id`, `token`, `created`, `avatar`, `notes`, `info`, `lastlogin`, `lastip`, `userlevel`, `active`) VALUES ('2', 'peter', '42b7b504b2753b71f41780d5e86f1139a2ab5647', 'Peter', 'Peterson', 'gewa@rogers.com', '1', '0', '0', '2011-04-28 08:30:05', '', '', '', '2010-06-01 14:11:52', '127.0.0.1', '1', 'n');
INSERT INTO `users` (`id`, `username`, `password`, `fname`, `lname`, `email`, `newsletter`, `cookie_id`, `token`, `created`, `avatar`, `notes`, `info`, `lastlogin`, `lastip`, `userlevel`, `active`) VALUES ('3', 'mike', '42b7b504b2753b71f41780d5e86f1139a2ab5647', 'Mike', 'Nelson', 'gewa@rogers.com', '0', '0', '0', '2011-05-30 17:28:17', '', '', '', '2010-08-07 12:35:54', '127.0.0.1', '1', 't');
INSERT INTO `users` (`id`, `username`, `password`, `fname`, `lname`, `email`, `newsletter`, `cookie_id`, `token`, `created`, `avatar`, `notes`, `info`, `lastlogin`, `lastip`, `userlevel`, `active`) VALUES ('4', 'john', '42b7b504b2753b71f41780d5e86f1139a2ab5647', 'John', 'Stevens', 'gewa@rogers.com', '0', '0', '0', '2011-06-15 00:58:31', '', '', '', '2010-06-18 13:34:47', '127.0.0.1', '1', 'y');


